/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.asn;

import com.nickoh.asn.BerUtilities;
import java.io.Serializable;
import java.util.Arrays;

public abstract class Asn1Structure
implements Serializable {
    protected byte[] byteStream = null;

    protected Asn1Structure() {
    }

    protected Asn1Structure(byte[] byteStream, byte initialTag) throws IllegalArgumentException {
        this(byteStream, 0, byteStream.length, initialTag);
    }

    protected Asn1Structure(byte[] byteStream, int startOffset, int streamLength, byte initialTag) throws IllegalArgumentException {
        if (streamLength < 2) {
            throw new IllegalArgumentException("Octet stream is not long enough");
        }
        if (streamLength + startOffset > byteStream.length) {
            throw new IllegalArgumentException("Octet stream is not long enough");
        }
        if (byteStream[startOffset] != initialTag) {
            throw new IllegalArgumentException("Missing expected tag : ");
        }
        int length = BerUtilities.getComponentLength(byteStream, startOffset);
        if (length != streamLength) {
            throw new IllegalArgumentException("Encoded length does not match length of supplied array");
        }
        this.byteStream = new byte[streamLength];
        try {
            System.arraycopy(byteStream, startOffset, this.byteStream, 0, streamLength);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public byte[] getRawData() {
        return this.byteStream;
    }

    protected static final boolean identicalByteStream(byte[] b1, byte[] b2) {
        return Arrays.equals(b1, b2);
    }

    protected static final boolean identicalByteStream(byte[] b1, int offset1, byte[] b2, int offset2, int length) {
        if (offset1 + length > b1.length) {
            return false;
        }
        if (offset2 + length > b2.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (b1[offset1] != b2[offset2]) {
                return false;
            }
            ++offset1;
            ++offset2;
            ++i;
        }
        return true;
    }
}

