/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.asn;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;

public class BerUtilities {
    private static final String moduleVersion = "1.0";
    public static final byte LBER_SEQUENCE = 48;
    public static final byte LBER_SET = 49;
    public static final byte LBER_BOOLEAN = 1;
    public static final byte LBER_INTEGER = 2;
    public static final byte LBER_BITSTRING = 3;
    public static final byte LBER_OCTETSTRING = 4;
    public static final byte LBER_NULL = 5;
    public static final byte LBER_ENUMERATED = 10;
    public static final byte LBER_CLASS_UNIVERSAL = 0;
    public static final byte LBER_CLASS_APPLICATION = 64;
    public static final byte LBER_CLASS_CONTEXT = -128;
    public static final byte LBER_CLASS_PRIVATE = -64;
    public static final byte LBER_OID = 6;
    public static final byte LBER_PRINTABLESTRING = 19;
    public static final byte LBER_CONSTRUCTED = 32;

    public static final byte[] appendToSetOrSequence(byte[] currentSequence, byte[] dataToAppend) {
        int requiredSize = BerUtilities.getLengthField(currentSequence, 0) + dataToAppend.length;
        byte[] newData = new byte[requiredSize];
        System.arraycopy(currentSequence, BerUtilities.dataOffset(currentSequence, 0), newData, 0, BerUtilities.getLengthField(currentSequence, 0));
        System.arraycopy(dataToAppend, 0, newData, BerUtilities.getLengthField(currentSequence, 0), dataToAppend.length);
        return BerUtilities.buildTLV(currentSequence[0], newData);
    }

    public static final byte[] buildLengthBytes(int val) {
        if (val < 128) {
            return new byte[]{(byte)val};
        }
        int b0 = -127;
        byte b1 = (byte)((val & 0xFF000000) >> 24);
        byte b2 = (byte)((val & 0xFF0000) >> 16);
        byte b3 = (byte)((val & 0xFF00) >> 8);
        byte b4 = (byte)(val & 0xFF);
        int byteCount = 2;
        if (b1 != 0) {
            byteCount = 5;
            b0 = -124;
        } else if (b2 != 0) {
            byteCount = 4;
            b0 = -125;
        } else if (b3 != 0) {
            byteCount = 3;
            b0 = -126;
        }
        byte[] retval = new byte[byteCount];
        retval[0] = b0;
        if (byteCount > 4) {
            retval[1] = b1;
        }
        if (byteCount > 3) {
            retval[byteCount - 3] = b2;
        }
        if (byteCount > 2) {
            retval[byteCount - 2] = b3;
        }
        retval[byteCount - 1] = b4;
        return retval;
    }

    public static byte[] buildTLV(byte tag, byte[] value) {
        byte[] lengthBytes = BerUtilities.buildLengthBytes(value.length);
        byte[] result = new byte[1 + lengthBytes.length + value.length];
        int position = 0;
        result[position] = tag;
        System.arraycopy(lengthBytes, 0, result, ++position, lengthBytes.length);
        System.arraycopy(value, 0, result, position += lengthBytes.length, value.length);
        return result;
    }

    public static final String byteToHex(byte param) {
        int i = param & 0xFF;
        String s = Integer.toString(i, 16);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s.toUpperCase();
    }

    public static final int hexToByte(byte param) {
        if (param >= 65 && param <= 70) {
            return param - 65 + 10;
        }
        if (param >= 97 && param <= 102) {
            return param - 97 + 10;
        }
        if (param >= 48 && param <= 57) {
            return param - 48;
        }
        return 0;
    }

    public static final int dataOffset(byte[] byteStream, int tagOffset) {
        int unsignedByte = byteStream[tagOffset + 1] & 0xFF;
        if (unsignedByte < 128) {
            return tagOffset + 2;
        }
        int numOctets = unsignedByte - 128;
        return tagOffset + numOctets + 2;
    }

    public static void dump(byte[] byteStream, PrintStream ps) {
        ps.println("Raw data :");
        int i = 0;
        while (i < byteStream.length) {
            ps.print("[" + BerUtilities.byteToHex((byte)i) + "] = " + BerUtilities.byteToHex(byteStream[i]) + " | ");
            if (i % 8 == 7) {
                ps.println();
            }
            ++i;
        }
        ps.println();
        ps.println("Decoded data:");
        BerUtilities.dumpTLV(ps, byteStream, 0, 0);
        ps.println();
    }

    private static void dumpTLV(PrintStream ps, byte[] byteStream, int startOffset, int indentationLevel) {
        try {
            byte tag = byteStream[startOffset];
            int length = BerUtilities.getLengthField(byteStream, startOffset);
            int dataOffset = BerUtilities.dataOffset(byteStream, startOffset);
            if ((tag & 0x20) == 0) {
                int s = 0;
                while (s < indentationLevel) {
                    ps.print(" ");
                    ++s;
                }
                ps.print("tag : 0x" + BerUtilities.byteToHex(tag));
                switch (tag) {
                    case 4: {
                        ps.print(" (LBER_OCTETSTRING)");
                        break;
                    }
                    case 2: {
                        ps.print(" (LBER_INTEGER)");
                        break;
                    }
                    case 10: {
                        ps.print(" (LBER_ENUMERATED)");
                        break;
                    }
                    case 19: {
                        ps.print(" (LBER_PRINTABLESTRING)");
                        break;
                    }
                    case 6: {
                        ps.print(" (LBER_OID)");
                        break;
                    }
                    case 1: {
                        ps.print(" (LBER_BOOLEAN)");
                        break;
                    }
                    case 3: {
                        ps.print(" (LBER_BITSTRING)");
                        break;
                    }
                    case 5: {
                        ps.print(" (LBER_NULL)");
                        break;
                    }
                    default: {
                        byte tagNumber = (byte)(tag & 0x1F);
                        byte tagClass = (byte)(tag & 0xFFFFFFC0);
                        if (tagClass == 64) {
                            ps.print(" APPLICATION");
                        }
                        if (tagClass == -128) {
                            ps.print(" CONTEXT");
                        }
                        if (tagClass == 0) {
                            ps.print(" UNIVERSAL");
                        }
                        if (tagClass == -64) {
                            ps.print(" PRIVATE");
                        }
                        ps.print("[" + tagNumber + "] primitive");
                    }
                }
                ps.println(", length = " + length);
                s = 0;
                while (s < indentationLevel) {
                    ps.print(" ");
                    ++s;
                }
                ps.print("value = ");
                switch (tag) {
                    case 4: 
                    case 19: {
                        ps.println("\"" + BerUtilities.getString(byteStream, startOffset) + "\"");
                        break;
                    }
                    case 2: 
                    case 10: {
                        ps.println(BerUtilities.getInteger(byteStream, startOffset));
                        break;
                    }
                    case 1: {
                        ps.println(BerUtilities.getInteger(byteStream, startOffset) != 0);
                        break;
                    }
                    default: {
                        ps.println("<not decoded>");
                    }
                }
                s = 0;
                while (s < indentationLevel) {
                    ps.print(" ");
                    ++s;
                }
                ps.println("bytes = ");
                s = 0;
                while (s < indentationLevel) {
                    ps.print(" ");
                    ++s;
                }
                int i = 0;
                while (i < length) {
                    ps.print("[" + BerUtilities.byteToHex((byte)i) + "] = " + BerUtilities.byteToHex(byteStream[i + dataOffset]) + " | ");
                    if (i % 8 == 7) {
                        ps.println();
                        s = 0;
                        while (s < indentationLevel) {
                            ps.print(" ");
                            ++s;
                        }
                    }
                    ++i;
                }
                return;
            }
            int s = 0;
            while (s < indentationLevel) {
                ps.print(" ");
                ++s;
            }
            byte tagClass = (byte)(tag & 0xFFFFFFC0);
            byte tagNumber = (byte)(tag & 0x1F);
            if (tagClass == 0) {
                switch (tag) {
                    case 48: {
                        ps.print("LBER_SEQUENCE");
                        break;
                    }
                    case 49: {
                        ps.print("LBER_SET");
                        break;
                    }
                    default: {
                        ps.print("UNIVERSAL[" + tagNumber + "]");
                    }
                }
            }
            if (tagClass == 64) {
                ps.print("APPLICATION[" + tagNumber + "]");
            }
            if (tagClass == -128) {
                ps.print("CONTEXT[" + tagNumber + "]");
            }
            if (tagClass == -64) {
                ps.print("PRIVATE[" + tagNumber + "]");
            }
            ps.println(", length = " + BerUtilities.getLengthField(byteStream, startOffset) + " :");
            int componentLength = BerUtilities.getComponentLength(byteStream, startOffset);
            int endPos = componentLength + startOffset - 1;
            int currPos = BerUtilities.dataOffset(byteStream, startOffset);
            while (currPos < endPos) {
                BerUtilities.dumpTLV(ps, byteStream, currPos, indentationLevel + 1);
                ps.println();
                currPos += BerUtilities.getComponentLength(byteStream, currPos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final byte[] encodeApplicationSpecific(byte[] value, byte tagNumber, boolean constructed) {
        byte tag = 64;
        tag = (byte)(tag | tagNumber & 0x1F);
        if (constructed) {
            tag = (byte)(tag | 0x20);
        }
        return BerUtilities.buildTLV(tag, value);
    }

    public static final byte[] encodeContextSpecific(byte[] value, byte tagNumber, boolean constructed) {
        byte tag = -128;
        tag = (byte)(tag | tagNumber & 0x1F);
        if (constructed) {
            tag = (byte)(tag | 0x20);
        }
        return BerUtilities.buildTLV(tag, value);
    }

    public static final byte[] encodeEnumerated(long value) {
        byte[] result = BerUtilities.encodeInteger(value);
        result[0] = 10;
        return result;
    }

    public static final byte[] encodeInteger(long value) {
        BigInteger bi = new BigInteger(Long.toString(value));
        byte[] valArray = bi.toByteArray();
        return BerUtilities.buildTLV((byte)2, valArray);
    }

    public static final byte[] encodeOctetString(String value) {
        byte[] valArray = value.getBytes();
        return BerUtilities.buildTLV((byte)4, valArray);
    }

    public static final byte[] encodeHexString(String value) {
        byte[] valArray = value.getBytes();
        byte[] newArray = new byte[value.length() / 2];
        int j = 0;
        int i = 0;
        while (i < value.length()) {
            int hexValue = BerUtilities.hexToByte(valArray[i]) * 16 + BerUtilities.hexToByte(valArray[i + 1]);
            newArray[j++] = (byte)hexValue;
            i += 2;
        }
        return BerUtilities.buildTLV((byte)4, newArray);
    }

    public static final byte[] encodeRfcString(String value) {
        int i;
        int nextByte;
        boolean nibble;
        String rfcString = value;
        byte[] newArray = new byte[15];
        byte[] byArray = new byte[6];
        byArray[0] = 84;
        byArray[2] = 114;
        byArray[3] = -121;
        byArray[4] = 34;
        byArray[5] = 3;
        byte[] osak__rfc1006_prefix = byArray;
        System.arraycopy(osak__rfc1006_prefix, 0, newArray, 0, 6);
        int portPos = rfcString.indexOf(43);
        if (portPos < 0) {
            portPos = rfcString.indexOf(58);
        }
        if (portPos >= 0) {
            String portString = rfcString.substring(portPos + 1);
            rfcString = rfcString.substring(0, portPos);
            while (portString.length() < 5) {
                portString = "0" + portString;
            }
            nibble = false;
            nextByte = 0;
            i = 0;
            while (i < 5) {
                if (!nibble) {
                    nextByte = (byte)BerUtilities.hexToByte((byte)portString.charAt(i));
                    nibble = true;
                } else {
                    newArray[12 + i / 2] = (byte)((nextByte << 4) + BerUtilities.hexToByte((byte)portString.charAt(i)));
                    nibble = false;
                }
                ++i;
            }
            newArray[14] = (byte)(nextByte << 4);
        } else {
            int i2 = 0;
            while (i2 < 3) {
                newArray[12 + i2] = 0;
                ++i2;
            }
        }
        int j = 6;
        nibble = false;
        nextByte = 0;
        i = 0;
        while (i < 4) {
            String component = null;
            int dotPos = rfcString.indexOf(46);
            if (dotPos >= 0) {
                component = rfcString.substring(0, dotPos);
                rfcString = rfcString.substring(dotPos + 1);
            } else {
                component = rfcString;
                rfcString = null;
            }
            while (component.length() < 3) {
                component = "0" + component;
            }
            int k = 0;
            while (k < 3) {
                if (!nibble) {
                    nextByte = (byte)BerUtilities.hexToByte((byte)component.charAt(k));
                    nibble = true;
                } else {
                    newArray[j] = (byte)((nextByte << 4) + BerUtilities.hexToByte((byte)component.charAt(k)));
                    nibble = false;
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        return BerUtilities.buildTLV((byte)4, newArray);
    }

    public static final byte[] encodePrintableString(String value) {
        byte[] valArray = value.getBytes();
        return BerUtilities.buildTLV((byte)19, valArray);
    }

    public static final byte[] encodeSequence(byte[] val) {
        return BerUtilities.buildTLV((byte)48, val);
    }

    public static final byte[] encodeSet(byte[] val) {
        return BerUtilities.buildTLV((byte)49, val);
    }

    public static final byte[] generateStream(byte[] byteStream, int startOffset, int length, int extraBytes, byte tag) {
        int totalBytes = length + extraBytes;
        byte[] lengthBytes = BerUtilities.buildLengthBytes(totalBytes);
        totalBytes += lengthBytes.length;
        byte[] result = new byte[++totalBytes];
        int offset = 0;
        result[offset++] = tag;
        int i = 0;
        while (i < lengthBytes.length) {
            result[offset++] = lengthBytes[i];
            ++i;
        }
        i = 0;
        while (i < length) {
            result[offset++] = byteStream[i + startOffset];
            ++i;
        }
        i = 0;
        while (i < extraBytes) {
            result[offset++] = 0;
            ++i;
        }
        return result;
    }

    public static final int getComponentLength(byte[] byteStream, int tagOffset) {
        int numLengthOctets;
        int offset = tagOffset + 1;
        int result = 0;
        try {
            int unsignedByte = byteStream[offset] & 0xFF;
            if (unsignedByte < 128) {
                return unsignedByte + 2;
            }
            ++offset;
            numLengthOctets = unsignedByte - 128;
            if (numLengthOctets > 4) {
                return -1;
            }
            int i = 0;
            while (i < numLengthOctets) {
                unsignedByte = byteStream[i + offset] & 0xFF;
                result = (result << 8) + unsignedByte;
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
        return result + numLengthOctets + 2;
    }

    public static final int getInteger(byte[] byteStream, int tagOffset) {
        boolean isNegative;
        int valueOffset = BerUtilities.dataOffset(byteStream, tagOffset);
        int numBytes = BerUtilities.getLengthField(byteStream, tagOffset);
        int result = 0;
        boolean bl = isNegative = byteStream[valueOffset] < 0;
        if (isNegative) {
            int leadingBytes = 4 - numBytes;
            int i = 0;
            while (i < leadingBytes) {
                result <<= 8;
                result += 255;
                ++i;
            }
        }
        int i = 0;
        while (i < numBytes) {
            result <<= 8;
            result += byteStream[valueOffset + i] & 0xFF;
            ++i;
        }
        return result;
    }

    public static final int getLengthField(byte[] byteStream, int offset) {
        int unsignedByte;
        if ((unsignedByte = byteStream[++offset] & 0xFF) < 128) {
            return unsignedByte;
        }
        int result = 0;
        ++offset;
        int numLengthOctets = unsignedByte - 128;
        int i = 0;
        while (i < numLengthOctets) {
            unsignedByte = byteStream[i + offset] & 0xFF;
            result = (result << 8) + unsignedByte;
            ++i;
        }
        return result;
    }

    public static final int getMemberCount(byte[] byteStream, int tagOffset) {
        int lastByte = tagOffset + BerUtilities.getComponentLength(byteStream, tagOffset);
        if (lastByte > byteStream.length) {
            return -1;
        }
        int count = -1;
        int offset = BerUtilities.dataOffset(byteStream, tagOffset);
        while (offset <= lastByte) {
            if (offset == lastByte) {
                ++count;
                break;
            }
            offset += BerUtilities.getComponentLength(byteStream, offset);
            ++count;
        }
        return count;
    }

    public static final String getString(byte[] byteStream, int tagOffset) {
        int valueOffset = BerUtilities.dataOffset(byteStream, tagOffset);
        int numBytes = BerUtilities.getLengthField(byteStream, tagOffset);
        return new String(byteStream, valueOffset, numBytes);
    }

    public static void main(String[] args) {
        byte[] resultArray;
        int result;
        int testNumber = 0;
        int testsPassed = 0;
        boolean passed = true;
        ++testNumber;
        String testName = "'positive LBER_INTEGER'";
        byte[] t1 = new byte[]{2, 1, 100};
        try {
            result = BerUtilities.getInteger(t1, 0);
            if (result == 100) {
                ++testsPassed;
            } else {
                System.out.println("Test " + testName + " failed, returned " + result + " instead of 100");
            }
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        ++testNumber;
        testName = "'negative LBER_INTEGER'";
        byte[] t2 = new byte[]{2, 1, -100};
        try {
            result = BerUtilities.getInteger(t2, 0);
            if (result == -100) {
                ++testsPassed;
            } else {
                System.out.println("Test " + testName + " failed, returned " + result + " instead of -100");
            }
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        ++testNumber;
        testName = "'encoding of a String'";
        byte[] t3 = new byte[]{4, 5, 65, 66, 67, 68, 69};
        String expectedString = "ABCDE";
        try {
            String resultString = BerUtilities.getString(t3, 0);
            if (resultString.equals(expectedString)) {
                ++testsPassed;
            } else {
                System.out.println("Test " + testName + " failed, returned " + resultString + " instead of " + expectedString);
            }
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        ++testNumber;
        passed = true;
        testName = "'test encodeInteger() [1]'";
        byte[] expectedArray = new byte[]{2, 2, 1, -123};
        try {
            byte[] resultArray2 = BerUtilities.encodeInteger(389L);
            if (resultArray2.length == expectedArray.length) {
                int i = 0;
                while (i < resultArray2.length) {
                    if (expectedArray[i] != resultArray2[i]) {
                        passed = false;
                        System.out.println("Test " + testName + " failed, data mismatch");
                    }
                    ++i;
                }
            } else {
                passed = false;
                System.out.println("Test " + testName + " failed, length mismatch");
            }
        }
        catch (Exception e) {
            passed = false;
            System.out.println("Error in test " + testName + ": " + e);
        }
        if (passed) {
            ++testsPassed;
        }
        ++testNumber;
        testName = "'test encodeInteger() [2]'";
        passed = true;
        try {
            int i = -10000;
            while (i < 10000) {
                byte[] resArray = BerUtilities.encodeInteger(i);
                int readBack = BerUtilities.getInteger(resArray, 0);
                if (readBack != i) {
                    passed = false;
                    System.out.println("Test " + testName + " failed, read " + readBack + " instead of " + i);
                }
                i += 100;
            }
        }
        catch (Exception e) {
            passed = false;
            System.out.println("Error in test " + testName + ": " + e);
        }
        if (passed) {
            ++testsPassed;
        }
        ++testNumber;
        testName = "'test encodeOctetString() [1]'";
        expectedString = "This is a test string";
        try {
            byte[] resArray = BerUtilities.encodeOctetString(expectedString);
            String retval = BerUtilities.getString(resArray, 0);
            if (retval.equals(expectedString)) {
                ++testsPassed;
            } else {
                System.out.println("Test " + testName + " failed, read " + retval + " instead of " + expectedString);
            }
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        ++testNumber;
        testName = "'test encodeContextSpecific'";
        passed = true;
        expectedArray = new byte[]{-96, 4, 2, 2, 1, -123};
        try {
            resultArray = BerUtilities.encodeInteger(389L);
            resultArray = BerUtilities.encodeContextSpecific(resultArray, (byte)0, true);
            if (resultArray.length == expectedArray.length) {
                int i = 0;
                while (i < resultArray.length) {
                    if (expectedArray[i] != resultArray[i]) {
                        passed = false;
                        System.out.println("Test " + testName + " failed, data mismatch");
                    }
                    ++i;
                }
            } else {
                passed = false;
                System.out.println("Test " + testName + " failed, length mismatch");
            }
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
            passed = false;
        }
        if (passed) {
            ++testsPassed;
        }
        ++testNumber;
        testName = "'test encodeApplicationSpecific'";
        passed = true;
        expectedArray = new byte[]{100, 5, 4, 3, 65, 66, 67};
        try {
            resultArray = BerUtilities.encodeOctetString("ABC");
            resultArray = BerUtilities.encodeApplicationSpecific(resultArray, (byte)4, true);
            if (resultArray.length == expectedArray.length) {
                int i = 0;
                while (i < resultArray.length) {
                    if (expectedArray[i] != resultArray[i]) {
                        passed = false;
                        System.out.println("Test " + testName + " failed, data mismatch");
                    }
                    ++i;
                }
            } else {
                passed = false;
                System.out.println("Test " + testName + " failed, length mismatch");
            }
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
            passed = false;
        }
        if (passed) {
            ++testsPassed;
        }
        ++testNumber;
        testName = "'test encodeSet()'";
        expectedString = "This is a test string";
        int expectedInteger = 12345;
        try {
            byte[] resArray = BerUtilities.encodeSet(BerUtilities.encodeContextSpecific(BerUtilities.encodeOctetString(expectedString), (byte)1, true));
            resArray = BerUtilities.appendToSetOrSequence(resArray, BerUtilities.encodeContextSpecific(BerUtilities.encodeInteger(expectedInteger), (byte)2, true));
            int pos = BerUtilities.dataOffset(resArray, 0);
            int tPos = BerUtilities.tagOffset(resArray, (byte)-95, pos);
            tPos = BerUtilities.dataOffset(resArray, tPos);
            String s = BerUtilities.getString(resArray, tPos);
            tPos = BerUtilities.tagOffset(resArray, (byte)-94, pos);
            tPos = BerUtilities.dataOffset(resArray, tPos);
            int i = BerUtilities.getInteger(resArray, tPos);
            if (i == expectedInteger && s.equals(expectedString)) {
                ++testsPassed;
            } else {
                System.out.println("Test " + testName + " failed, read " + s + ", " + i + " instead of " + expectedString + ", " + expectedInteger);
            }
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        System.out.print("Test of BerUtilities 1.0  ");
        if (testNumber == testsPassed) {
            System.out.println("All " + testsPassed + " tests passed.");
        } else {
            System.out.println("**** Only " + testsPassed + " tests out of " + testNumber + " passed ****");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final int tagOffset(byte[] byteStream, byte tag, int startOffset) {
        if (startOffset < byteStream.length) ** GOTO lbl5
        return -1;
lbl-1000:
        // 1 sources

        {
            if ((startOffset += BerUtilities.getComponentLength(byteStream, startOffset)) < byteStream.length) continue;
            return -1;
lbl5:
            // 2 sources

            ** while (byteStream[startOffset] != tag)
        }
lbl6:
        // 1 sources

        return startOffset;
    }

    public static byte[] getNextMessage(InputStream iStream) throws IOException {
        byte[] retval = null;
        byte[] prefix = new byte[9];
        int prefixLength = iStream.read(prefix, 0, 2);
        if (prefixLength != 2) {
            throw new EOFException();
        }
        try {
            if (prefix[1] <= 0) {
                int numBytes = prefix[1] + 128;
                prefixLength += iStream.read(prefix, 2, numBytes);
            }
            int dataLength = BerUtilities.getLengthField(prefix, 0);
            retval = new byte[prefixLength + dataLength];
            System.arraycopy(prefix, 0, retval, 0, prefixLength);
            int remainingData = dataLength;
            int startPos = prefixLength;
            while (remainingData > 0) {
                int count = iStream.read(retval, startPos, remainingData);
                remainingData -= count;
                startPos += count;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException(e.getMessage());
        }
        return retval;
    }
}

