/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.asn;

import com.nickoh.asn.Asn1Structure;
import com.nickoh.asn.BerUtilities;

public class Oid
extends Asn1Structure {
    private static final String moduleVersion = "1.0";
    private static final String localityOID = "2.5.4.7";
    private static final String commonNameOID = "2.5.4.3";
    private static final String domainComponentOID = "0.9.2432.19200300.100.1.25";
    private static final String organizationOID = "2.5.4.10";
    private static final String countryOID = "2.5.4.6";
    private static final String orgUnitOID = "2.5.4.11";

    public Oid(byte[] byteStream) throws IllegalArgumentException {
        this(byteStream, 0, byteStream.length);
    }

    public Oid(byte[] byteStream, int startOffset, int streamLength) throws IllegalArgumentException {
        super(byteStream, startOffset, streamLength, (byte)6);
        try {
            this.dottedString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Octet stream is not long enough");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String dottedString() {
        int offset = BerUtilities.dataOffset(this.byteStream, 0);
        int length = BerUtilities.getLengthField(this.byteStream, 0);
        boolean count = false;
        boolean firstSubId = true;
        String result = null;
        while (length > 0) {
            int value = this.byteStream[offset] & 0x7F;
            while ((this.byteStream[offset++] & 0x80) != 0) {
                value <<= 7;
                value += this.byteStream[offset] & 0x7F;
                --length;
            }
            if (firstSubId) {
                firstSubId = false;
                int comp1 = value / 40 % 3;
                int comp2 = value - comp1 * 40;
                result = String.valueOf(comp1) + "." + comp2;
            } else {
                result = String.valueOf(result) + "." + value;
            }
            --length;
        }
        return result;
    }

    public String toString() {
        String retval = this.dottedString();
        if (commonNameOID.equals(retval)) {
            return "CN";
        }
        if (countryOID.equals(retval)) {
            return "C";
        }
        if (domainComponentOID.equalsIgnoreCase(retval)) {
            return "DC";
        }
        if (organizationOID.equals(retval)) {
            return "O";
        }
        if (orgUnitOID.equals(retval)) {
            return "OU";
        }
        if (localityOID.equals(retval)) {
            return "L";
        }
        return retval;
    }

    public static final byte[] getEncodedOID(String oidString) {
        if (oidString.compareToIgnoreCase("CN") == 0) {
            return new Oid(new byte[]{6, 3, 85, 4, 3}).getRawData();
        }
        if (oidString.compareToIgnoreCase("C") == 0) {
            return new Oid(new byte[]{6, 3, 85, 4, 6}).getRawData();
        }
        if (oidString.compareToIgnoreCase("DC") == 0) {
            byte[] byArray = new byte[12];
            byArray[0] = 6;
            byArray[1] = 10;
            byArray[2] = 9;
            byArray[3] = -109;
            byArray[5] = -119;
            byArray[6] = -109;
            byArray[7] = -14;
            byArray[8] = 44;
            byArray[9] = 100;
            byArray[10] = 1;
            byArray[11] = 25;
            return new Oid(byArray).getRawData();
        }
        if (oidString.compareToIgnoreCase("O") == 0) {
            return new Oid(new byte[]{6, 3, 85, 4, 10}).getRawData();
        }
        if (oidString.compareToIgnoreCase("OU") == 0) {
            return new Oid(new byte[]{6, 3, 85, 4, 11}).getRawData();
        }
        if (oidString.compareToIgnoreCase("L") == 0) {
            return new Oid(new byte[]{6, 3, 85, 4, 7}).getRawData();
        }
        return null;
    }

    public static void main(String[] args) {
        int testNumber = 0;
        int testsPassed = 0;
        Oid o = null;
        ++testNumber;
        String testName = "invalid oid(1)";
        try {
            o = new Oid(new byte[1]);
            System.out.println("Test " + testName + " failed, no exception thrown");
        }
        catch (IllegalArgumentException e) {
            ++testsPassed;
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        ++testNumber;
        testName = "invalid oid(2)";
        try {
            o = new Oid(new byte[]{2, 2, 1});
            System.out.println("Test " + testName + " failed, no exception thrown");
        }
        catch (IllegalArgumentException e) {
            ++testsPassed;
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        ++testNumber;
        testName = "invalid oid(3)";
        try {
            o = new Oid(new byte[]{6, 3, 9, -110, -80});
            System.out.println("Test " + testName + " failed, no exception thrown");
        }
        catch (IllegalArgumentException e) {
            ++testsPassed;
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        ++testNumber;
        testName = "valid oid with that should have locality (2.5.4.7)";
        try {
            o = new Oid(new byte[]{6, 3, 85, 4, 7});
            if (o.toString().equals("L") && o.dottedString().equals(localityOID)) {
                ++testsPassed;
            } else {
                System.out.println("Test " + testName + " failed, returned OID was " + o.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        ++testNumber;
        testName = "valid oid with that should have DC (0.9.2432.19200300.100.1.25)";
        try {
            byte[] byArray = new byte[12];
            byArray[0] = 6;
            byArray[1] = 10;
            byArray[2] = 9;
            byArray[3] = -109;
            byArray[5] = -119;
            byArray[6] = -109;
            byArray[7] = -14;
            byArray[8] = 44;
            byArray[9] = 100;
            byArray[10] = 1;
            byArray[11] = 25;
            byte[] dcByte = byArray;
            o = new Oid(dcByte);
            if (o.toString().equals("DC") && o.dottedString().equals(domainComponentOID)) {
                ++testsPassed;
            } else {
                System.out.println("Test " + testName + " failed, returned OID was " + o.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Error in test " + testName + ": " + e);
        }
        System.out.print("Test of OID version 1.0 : ");
        if (testNumber == testsPassed) {
            System.out.println("All " + testsPassed + " tests passed.");
        } else {
            System.out.println("**** Only " + testsPassed + " tests out of " + testNumber + " passed ****");
        }
    }
}

