/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.asn;

import com.nickoh.asn.Asn1Structure;
import com.nickoh.asn.BerUtilities;
import com.nickoh.asn.Oid;
import com.nickoh.snooper.ASN1Decoder;
import com.nickoh.snooper.HexDecoder;
import com.nickoh.util.Dates;
import java.util.Calendar;
import java.util.TimeZone;

public class X509Certificate
extends Asn1Structure {
    private int versionNumber = -1;
    private int innerSeqOffset = BerUtilities.dataOffset(this.byteStream, 0);
    private int innerSeqData = BerUtilities.dataOffset(this.byteStream, this.innerSeqOffset);
    private int serialNumber = -1;
    private int signatureOffset = BerUtilities.tagOffset(this.byteStream, (byte)48, this.innerSeqData);
    private int issuerOffset = -1;
    private int validityOffset = -1;
    private int subjectOffset = -1;
    private int subjectPkiOffset = -1;
    private Oid algorithmId = null;
    private String issuer = null;
    private String notBefore = null;
    private String notAfter = null;
    private String subject = null;
    private Oid pkiAlgorithmId = null;
    private String subjectPublicKey = null;

    public X509Certificate(byte[] byteStream) {
        this(byteStream, 0, byteStream.length);
    }

    public X509Certificate(byte[] byteStream, int startOffset, int streamLength) {
        super(byteStream, startOffset, streamLength, (byte)48);
        int signatureLength = BerUtilities.getComponentLength(this.byteStream, this.signatureOffset);
        this.issuerOffset = BerUtilities.tagOffset(this.byteStream, (byte)48, this.signatureOffset + signatureLength);
        int issuerLength = BerUtilities.getComponentLength(this.byteStream, this.issuerOffset);
        this.validityOffset = BerUtilities.tagOffset(this.byteStream, (byte)48, this.issuerOffset + issuerLength);
        int validityLength = BerUtilities.getComponentLength(this.byteStream, this.validityOffset);
        this.subjectOffset = BerUtilities.tagOffset(this.byteStream, (byte)48, this.validityOffset + validityLength);
        int subjectLength = BerUtilities.getComponentLength(this.byteStream, this.subjectOffset);
        this.subjectPkiOffset = BerUtilities.tagOffset(this.byteStream, (byte)48, this.subjectOffset + subjectLength);
    }

    public Oid getAlgorithmId() {
        if (this.algorithmId != null) {
            return this.algorithmId;
        }
        int idOffset = BerUtilities.dataOffset(this.byteStream, this.signatureOffset);
        int idLen = BerUtilities.getComponentLength(this.byteStream, idOffset);
        this.algorithmId = new Oid(this.byteStream, idOffset, idLen);
        return this.algorithmId;
    }

    public String getAlgorithmType() {
        int idOffset = BerUtilities.dataOffset(this.byteStream, this.signatureOffset);
        int idLen = BerUtilities.getComponentLength(this.byteStream, idOffset);
        int typeOffset = idOffset + idLen;
        int typeLen = BerUtilities.getComponentLength(this.byteStream, typeOffset);
        return ASN1Decoder.decodeTLV(this.byteStream, typeOffset, typeLen, 0);
    }

    public String getIssuer() {
        if (this.issuer != null) {
            return this.issuer;
        }
        int setOffset = BerUtilities.dataOffset(this.byteStream, this.issuerOffset);
        int setLength = BerUtilities.getComponentLength(this.byteStream, setOffset);
        int seqOffset = BerUtilities.dataOffset(this.byteStream, setOffset);
        while (seqOffset < this.validityOffset) {
            int oidOffset = BerUtilities.dataOffset(this.byteStream, seqOffset);
            int oidLength = BerUtilities.getComponentLength(this.byteStream, oidOffset);
            Oid oid = new Oid(this.byteStream, oidOffset, oidLength);
            int valOffset = oidOffset + oidLength;
            String val = BerUtilities.getString(this.byteStream, valOffset);
            this.issuer = this.issuer == null ? String.valueOf(oid.toString()) + "=" + val : String.valueOf(this.issuer) + ", " + oid.toString() + "=" + val;
            setLength = BerUtilities.getComponentLength(this.byteStream, setOffset += setLength);
            seqOffset = BerUtilities.dataOffset(this.byteStream, setOffset);
        }
        return this.issuer;
    }

    public String getNotAfter() {
        if (this.notAfter != null) {
            return this.notAfter;
        }
        int nbOffset = BerUtilities.dataOffset(this.byteStream, this.validityOffset);
        int nbLength = BerUtilities.getComponentLength(this.byteStream, nbOffset);
        int naOffset = nbOffset + nbLength;
        String temp = BerUtilities.getString(this.byteStream, naOffset);
        if (this.byteStream[nbOffset] != 23) {
            this.notAfter = temp;
            return this.notAfter;
        }
        this.notAfter = X509Certificate.parseUTC(temp);
        return this.notAfter;
    }

    public String getNotBefore() {
        if (this.notBefore != null) {
            return this.notBefore;
        }
        int nbOffset = BerUtilities.dataOffset(this.byteStream, this.validityOffset);
        int nbLength = BerUtilities.getComponentLength(this.byteStream, nbOffset);
        String temp = BerUtilities.getString(this.byteStream, nbOffset);
        if (this.byteStream[nbOffset] != 23) {
            this.notBefore = temp;
            return this.notBefore;
        }
        this.notBefore = X509Certificate.parseUTC(temp);
        return this.notBefore;
    }

    public Oid getPkiAlgorithmId() {
        if (this.pkiAlgorithmId != null) {
            return this.pkiAlgorithmId;
        }
        int seqOffset = BerUtilities.dataOffset(this.byteStream, this.subjectPkiOffset);
        int idOffset = BerUtilities.dataOffset(this.byteStream, seqOffset);
        int idLen = BerUtilities.getComponentLength(this.byteStream, idOffset);
        this.pkiAlgorithmId = new Oid(this.byteStream, idOffset, idLen);
        return this.pkiAlgorithmId;
    }

    public int getSerialNumber() {
        if (this.serialNumber != -1) {
            return this.serialNumber;
        }
        byte tagToFind = 2;
        int serialNumberOffset = BerUtilities.tagOffset(this.byteStream, tagToFind, this.innerSeqData);
        if (serialNumberOffset == -1) {
            return -1;
        }
        this.serialNumber = BerUtilities.getInteger(this.byteStream, serialNumberOffset);
        return this.serialNumber;
    }

    public String getSubject() {
        if (this.subject != null) {
            return this.subject;
        }
        int setOffset = BerUtilities.dataOffset(this.byteStream, this.subjectOffset);
        int setLength = BerUtilities.getComponentLength(this.byteStream, setOffset);
        int seqOffset = BerUtilities.dataOffset(this.byteStream, setOffset);
        while (seqOffset < this.subjectPkiOffset) {
            int oidOffset = BerUtilities.dataOffset(this.byteStream, seqOffset);
            int oidLength = BerUtilities.getComponentLength(this.byteStream, oidOffset);
            Oid oid = new Oid(this.byteStream, oidOffset, oidLength);
            int valOffset = oidOffset + oidLength;
            String val = BerUtilities.getString(this.byteStream, valOffset);
            this.subject = this.subject == null ? String.valueOf(oid.toString()) + "=" + val : String.valueOf(this.subject) + ", " + oid.toString() + "=" + val;
            setLength = BerUtilities.getComponentLength(this.byteStream, setOffset += setLength);
            seqOffset = BerUtilities.dataOffset(this.byteStream, setOffset);
        }
        return this.subject;
    }

    public String getSubjectPublicKey() {
        if (this.subjectPublicKey != null) {
            return this.subjectPublicKey;
        }
        int seqOffset = BerUtilities.dataOffset(this.byteStream, this.subjectPkiOffset);
        int seqLen = BerUtilities.getComponentLength(this.byteStream, seqOffset);
        int keyOffset = seqOffset + seqLen;
        int keyLen = BerUtilities.getLengthField(this.byteStream, keyOffset);
        this.subjectPublicKey = HexDecoder.hexify(this.byteStream, BerUtilities.dataOffset(this.byteStream, keyOffset), keyLen);
        return this.subjectPublicKey;
    }

    public int getVersionNumber() {
        if (this.versionNumber != -1) {
            return this.versionNumber;
        }
        byte tagToFind = -96;
        int context0Offset = BerUtilities.tagOffset(this.byteStream, tagToFind, this.innerSeqData);
        if (context0Offset == -1) {
            this.versionNumber = 1;
        } else {
            int verOffset = BerUtilities.dataOffset(this.byteStream, context0Offset);
            this.versionNumber = BerUtilities.getInteger(this.byteStream, verOffset);
            ++this.versionNumber;
        }
        return this.versionNumber;
    }

    public static final String parseUTC(String utcString) {
        try {
            int year = Integer.parseInt(utcString.substring(0, 2));
            year = year < 50 ? (year += 2000) : (year += 1900);
            int month = Integer.parseInt(utcString.substring(2, 4));
            int day = Integer.parseInt(utcString.substring(4, 6));
            int hour = Integer.parseInt(utcString.substring(6, 8));
            int mins = Integer.parseInt(utcString.substring(8, 10));
            int sec = Integer.parseInt(utcString.substring(10, 12));
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.setLenient(false);
            cal.set(year, month - 1, day, hour, mins, sec);
            return Dates.VMSDate(cal.getTime());
        }
        catch (Exception e) {
            return utcString;
        }
    }
}

