/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.asn.BerUtilities;
import com.nickoh.asn.Oid;
import com.nickoh.snooper.Decoder;
import java.io.ByteArrayOutputStream;

public class ASN1Decoder
extends Decoder {
    private static final String moduleVersion = "1.0";
    public static final int initialCacheSize = 8192;
    protected ByteArrayOutputStream cache = new ByteArrayOutputStream(8192);
    public static final String errorPrefix = "Error : ";

    protected void checkForCompleteMessage() {
        try {
            while (this.hasCompleteAsn1Message()) {
                byte[] message = this.cache.toByteArray();
                int realMessageLength = BerUtilities.getComponentLength(message, 0);
                this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n");
                String temp = ASN1Decoder.decodeTLV(message, 0, realMessageLength - 1, 2);
                this.displayMessage(temp);
                this.cache.reset();
                if (realMessageLength >= message.length) continue;
                this.cache.write(message, realMessageLength, message.length - realMessageLength);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n *** " + e.getMessage() + " Message discarded. ***\n");
            this.cache.reset();
            return;
        }
    }

    public synchronized void decodeData(byte[] byteArray) {
        this.decodeData(byteArray, byteArray.length);
    }

    public synchronized void decodeData(byte[] byteArray, int length) {
        if (this.cache.size() == 0) {
            this.setTimestamp();
        }
        this.cache.write(byteArray, 0, length);
        this.checkForCompleteMessage();
    }

    public static String decodeTLV(byte[] byteStream, int startOffset, int endOffset, int indentationLevel) {
        String eol = "\n";
        String retval = "";
        String indentPrefix = "";
        int s = 0;
        while (s < indentationLevel) {
            indentPrefix = String.valueOf(indentPrefix) + " ";
            ++s;
        }
        try {
            byte tag = byteStream[startOffset];
            int length = BerUtilities.getLengthField(byteStream, startOffset);
            int dataOffset = BerUtilities.dataOffset(byteStream, startOffset);
            if ((tag & 0x20) == 0) {
                retval = String.valueOf(retval) + indentPrefix;
                retval = String.valueOf(retval) + "tag : 0x" + BerUtilities.byteToHex(tag);
                switch (tag) {
                    case 4: {
                        retval = String.valueOf(retval) + " (LBER_OCTETSTRING)";
                        break;
                    }
                    case 2: {
                        retval = String.valueOf(retval) + " (LBER_INTEGER)";
                        break;
                    }
                    case 10: {
                        retval = String.valueOf(retval) + " (LBER_ENUMERATED)";
                        break;
                    }
                    case 19: {
                        retval = String.valueOf(retval) + " (LBER_PRINTABLESTRING)";
                        break;
                    }
                    case 6: {
                        retval = String.valueOf(retval) + " (LBER_OID)";
                        break;
                    }
                    case 1: {
                        retval = String.valueOf(retval) + " (LBER_BOOLEAN)";
                        break;
                    }
                    case 3: {
                        retval = String.valueOf(retval) + " (LBER_BITSTRING)";
                        break;
                    }
                    case 5: {
                        retval = String.valueOf(retval) + " (LBER_NULL)";
                        break;
                    }
                    default: {
                        byte tagNumber = (byte)(tag & 0x1F);
                        byte tagClass = (byte)(tag & 0xFFFFFFC0);
                        if (tagClass == 64) {
                            retval = String.valueOf(retval) + " APPLICATION";
                        }
                        if (tagClass == -128) {
                            retval = String.valueOf(retval) + " CONTEXT";
                        }
                        if (tagClass == 0) {
                            retval = String.valueOf(retval) + " UNIVERSAL";
                        }
                        if (tagClass == -64) {
                            retval = String.valueOf(retval) + " PRIVATE";
                        }
                        retval = String.valueOf(retval) + "[" + tagNumber + "] primitive";
                    }
                }
                retval = String.valueOf(retval) + ", length = " + length + "\n";
                retval = String.valueOf(retval) + indentPrefix;
                retval = String.valueOf(retval) + "value = ";
                switch (tag) {
                    case 4: {
                        retval = String.valueOf(retval) + "\"" + Decoder.makePrintable(BerUtilities.getString(byteStream, startOffset)) + "\"" + "\n";
                        break;
                    }
                    case 19: {
                        retval = String.valueOf(retval) + "\"" + BerUtilities.getString(byteStream, startOffset) + "\"" + "\n";
                        break;
                    }
                    case 2: 
                    case 10: {
                        retval = String.valueOf(retval) + BerUtilities.getInteger(byteStream, startOffset) + "\n";
                        break;
                    }
                    case 6: {
                        Oid o = new Oid(byteStream, startOffset, BerUtilities.getComponentLength(byteStream, startOffset));
                        retval = String.valueOf(retval) + o.dottedString() + " (\"" + o.toString() + "\")" + "\n";
                        break;
                    }
                    case 1: {
                        retval = String.valueOf(retval) + (BerUtilities.getInteger(byteStream, startOffset) != 0) + "\n";
                        break;
                    }
                    default: {
                        retval = String.valueOf(retval) + "<not decoded>" + "\n";
                    }
                }
                retval = String.valueOf(retval) + indentPrefix;
                retval = String.valueOf(retval) + "bytes = ";
                int i = 0;
                while (i < length) {
                    retval = String.valueOf(retval) + "[" + BerUtilities.byteToHex((byte)i) + "]=" + BerUtilities.byteToHex(byteStream[i + dataOffset]) + "  ";
                    if (i % 8 == 7) {
                        retval = String.valueOf(retval) + "\n";
                        retval = String.valueOf(retval) + indentPrefix + "        ";
                    }
                    ++i;
                }
                return String.valueOf(retval) + "\n";
            }
            retval = String.valueOf(retval) + indentPrefix;
            byte tagClass = (byte)(tag & 0xFFFFFFC0);
            byte tagNumber = (byte)(tag & 0x1F);
            if (tagClass == 0) {
                switch (tag) {
                    case 48: {
                        retval = String.valueOf(retval) + "LBER_SEQUENCE";
                        break;
                    }
                    case 49: {
                        retval = String.valueOf(retval) + "LBER_SET";
                        break;
                    }
                    default: {
                        retval = String.valueOf(retval) + "UNIVERSAL[" + tagNumber + "]";
                    }
                }
            }
            if (tagClass == 64) {
                retval = String.valueOf(retval) + "APPLICATION[" + tagNumber + "]";
            }
            if (tagClass == -128) {
                retval = String.valueOf(retval) + "CONTEXT[" + tagNumber + "]";
            }
            if (tagClass == -64) {
                retval = String.valueOf(retval) + "PRIVATE[" + tagNumber + "]";
            }
            retval = String.valueOf(retval) + ", length = " + BerUtilities.getLengthField(byteStream, startOffset) + " :" + "\n";
            int componentLength = BerUtilities.getComponentLength(byteStream, startOffset);
            int endPos = componentLength + startOffset - 1;
            if (endPos > endOffset) {
                retval = String.valueOf(retval) + indentPrefix + "*** INVALID ASN.1 : length field overrun ***" + "\n";
                return errorPrefix + retval;
            }
            int currPos = BerUtilities.dataOffset(byteStream, startOffset);
            while (currPos < endPos) {
                retval = String.valueOf(retval) + ASN1Decoder.decodeTLV(byteStream, currPos, endPos, indentationLevel + 1);
                currPos += BerUtilities.getComponentLength(byteStream, currPos);
            }
        }
        catch (IndexOutOfBoundsException e) {
            retval = "Error : Index out of bounds, probable invalid length field";
        }
        return retval;
    }

    public String getName() {
        return "ASN.1 Decoder";
    }

    public String getVersion() {
        return moduleVersion;
    }

    public synchronized boolean hasCompleteAsn1Message() {
        if (this.cache.size() < 2) {
            return false;
        }
        byte[] message = this.cache.toByteArray();
        int lenLength = 1;
        if (message[1] <= 0) {
            lenLength = message[1] + 129;
        }
        if (message.length < 1 + lenLength) {
            return false;
        }
        int realMessageLength = BerUtilities.getComponentLength(message, 0);
        if (realMessageLength == -1) {
            this.cache.reset();
            throw new ArrayIndexOutOfBoundsException("Invalid length field at start of ASN.1 message");
        }
        return realMessageLength <= message.length;
    }

    public synchronized void reset() {
        this.cache.reset();
    }
}

