/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.CDPSink;
import com.nickoh.snooper.ConnectionDetailsPanel;
import com.nickoh.snooper.Decoder;
import com.nickoh.snooper.ProxyServer;
import com.nickoh.snooper.TwowaySnooper;
import com.nickoh.util.NickohLogHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class CDPProxy
extends ProxyServer {
    private static final String moduleVersion = "1.0";
    private static Logger logger = NickohLogHandler.getLogger();
    protected JTabbedPane tabbedPane;
    private final String serverName;
    protected Vector cdpVector;
    static /* synthetic */ Class class$0;

    private CDPProxy(InetAddress server, int serverPort, int listenPort, Class decoderClass, Class sinkClass) throws IOException {
        super(server, serverPort, listenPort, decoderClass, sinkClass);
        this.cdpVector = null;
        this.serverName = String.valueOf(server.getHostName()) + ":" + serverPort;
        logger.info("CDPProxy initialised for " + this.serverName);
        this.cdpVector = new Vector();
    }

    public CDPProxy(InetAddress server, int serverPort, int listenPort, JTabbedPane tabbedPane, Class decoderClass) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.nickoh.snooper.CDPSink");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(server, serverPort, listenPort, decoderClass, (Class)clazz);
        this.tabbedPane = tabbedPane;
    }

    protected void cleanup() {
        int i = 0;
        while (i < this.connectionCount) {
            this.removeConnection(i);
            ++i;
        }
        super.cleanup();
    }

    protected TwowaySnooper createTwowaySnooper(Socket clientSocket, Decoder clientDecoder, Decoder serverDecoder) {
        TwowaySnooper tws;
        ConnectionDetailsPanel cdp = (ConnectionDetailsPanel)this.cdpVector.get(this.connectionCount);
        String decoderName = this.decoderClass.getName();
        if (decoderName.lastIndexOf(".") != -1) {
            decoderName = decoderName.substring(decoderName.lastIndexOf(".") + 1);
        }
        String tabTitle = String.valueOf(decoderName) + " to " + this.serverName;
        final int newPos = this.tabbedPane.getTabCount();
        this.tabbedPane.insertTab(tabTitle, null, cdp, null, newPos);
        cdp.tws = tws = super.createTwowaySnooper(clientSocket, clientDecoder, serverDecoder);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CDPProxy.this.tabbedPane.setSelectedIndex(newPos);
            }
        });
        if (tws == null) {
            this.removeConnection(this.connectionCount);
        }
        return tws;
    }

    protected void removeConnection(int index) {
        logger.info("CDPProxy removeConnection #" + index);
        ConnectionDetailsPanel cdp = (ConnectionDetailsPanel)this.cdpVector.get(index);
        if (cdp != null) {
            CDPProxy cDPProxy = this;
            synchronized (cDPProxy) {
                this.cdpVector.set(index, null);
            }
            cdp.shutdown(null);
        }
    }

    protected Decoder setupClientDecoder(InetAddress client) {
        ConnectionDetailsPanel cdp = new ConnectionDetailsPanel();
        CDPProxy cDPProxy = this;
        synchronized (cDPProxy) {
            this.cdpVector.setSize(this.connectionCount + 1);
            this.cdpVector.set(this.connectionCount, cdp);
        }
        String clientName = client.getHostName();
        String cdpTitle = "Connection #" + this.connectionCount + " from " + clientName + " to " + this.serverName;
        cdp.setTitle(cdpTitle);
        cdp.setNumSources(2);
        cdp.setSourceName(0, "data from " + clientName + " to " + this.serverName);
        cdp.setSourceName(1, "data from " + this.serverName + " to " + clientName);
        CDPSink cs = new CDPSink(cdp, 0);
        try {
            Decoder d = (Decoder)this.decoderClass.newInstance();
            d.setSink(cs);
            d.setName("Message from " + clientName + " to " + this.serverName);
            return d;
        }
        catch (Exception e) {
            logger.info("CDPProxy, error instantiating clientDecoder : " + e);
            this.cdpVector.set(this.connectionCount, null);
            return null;
        }
    }

    protected Decoder setupServerDecoder() {
        ConnectionDetailsPanel cdp = (ConnectionDetailsPanel)this.cdpVector.get(this.connectionCount);
        CDPSink cs = new CDPSink(cdp, 1);
        try {
            Decoder d = (Decoder)this.decoderClass.newInstance();
            d.setSink(cs);
            d.setName(cdp.getSourceName(1));
            return d;
        }
        catch (Exception e) {
            logger.info("CDPProxy, error instantiating serverDecoder : " + e);
            this.cdpVector.set(this.connectionCount, null);
            return null;
        }
    }
}

