/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.TwowaySnooper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ConnectionDetailsPanel
extends JPanel {
    private static final String moduleVersion = "1.0";
    private JPanel ivjbuttonPanel = null;
    private FlowLayout ivjbuttonPanelFlowLayout = null;
    private JPanel ivjcentrePanel = null;
    private JButton ivjclearButton = null;
    private JButton ivjshutdownButton = null;
    protected TitledBorder myborder = null;
    private JScrollPane ivjJScrollPane1 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JTextPane ivjJTextPane1 = null;
    protected static Color[] colors = new Color[]{Color.blue, Color.red, Color.magenta, Color.darkGray, Color.black};
    protected static SimpleAttributeSet[] sa = new SimpleAttributeSet[colors.length];
    private JPanel ivjcheckBoxPanel = null;
    private GridLayout ivjcheckBoxPanelGridLayout = null;
    private int numSources = 0;
    protected JCheckBox[] checkBoxes = null;
    public static final int maxSources = 10;
    public TwowaySnooper tws = null;
    private JButton ivjcaptionButton = null;
    private TitledBorder myBorder = null;

    static {
        int i = 0;
        while (i < colors.length) {
            ConnectionDetailsPanel.sa[i] = new SimpleAttributeSet();
            StyleConstants.setForeground(sa[i], colors[i]);
            ++i;
        }
    }

    public ConnectionDetailsPanel() {
        this.initialize();
    }

    public ConnectionDetailsPanel(LayoutManager layout) {
        super(layout);
    }

    public ConnectionDetailsPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public ConnectionDetailsPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public void appendText(final String text, int source) {
        if (source > this.numSources) {
            return;
        }
        if (!this.checkBoxes[source].isSelected()) {
            return;
        }
        final Document d = this.getJTextPane1().getDocument();
        final SimpleAttributeSet s = sa[source % sa.length];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int pos = d.getLength();
                try {
                    d.insertString(pos, text, s);
                }
                catch (BadLocationException e) {
                    System.out.println("oops : " + e);
                }
            }
        });
    }

    public void captionButton_ActionPerformed(ActionEvent actionEvent) {
        JLabel promptLabel = new JLabel("Enter new caption");
        JTextField newCaptionText = new JTextField(this.getTitle());
        newCaptionText.setSelectionStart(0);
        newCaptionText.setSelectionEnd(newCaptionText.getText().length());
        JPanel jp = new JPanel(new GridLayout(2, 1));
        jp.add(promptLabel);
        jp.add(newCaptionText);
        int result = JOptionPane.showConfirmDialog(this, jp, "Change caption", 2);
        if (result != 0) {
            return;
        }
        this.setTitle(newCaptionText.getText());
        this.revalidate();
        this.repaint();
    }

    protected void clearButton_ActionPerformed(ActionEvent actionEvent) {
        ConnectionDetailsPanel connectionDetailsPanel = this;
        synchronized (connectionDetailsPanel) {
            this.getJTextPane1().setText("");
        }
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.clearButton_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.shutdownButton_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.captionButton_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getbuttonPanel() {
        if (this.ivjbuttonPanel == null) {
            try {
                this.ivjbuttonPanel = new JPanel();
                this.ivjbuttonPanel.setName("buttonPanel");
                this.ivjbuttonPanel.setLayout(this.getbuttonPanelFlowLayout());
                this.getbuttonPanel().add((Component)this.getcaptionButton(), this.getcaptionButton().getName());
                this.getbuttonPanel().add((Component)this.getclearButton(), this.getclearButton().getName());
                this.getbuttonPanel().add((Component)this.getshutdownButton(), this.getshutdownButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbuttonPanel;
    }

    private FlowLayout getbuttonPanelFlowLayout() {
        FlowLayout ivjbuttonPanelFlowLayout = null;
        try {
            ivjbuttonPanelFlowLayout = new FlowLayout();
            ivjbuttonPanelFlowLayout.setHgap(20);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjbuttonPanelFlowLayout;
    }

    private JButton getcaptionButton() {
        if (this.ivjcaptionButton == null) {
            try {
                this.ivjcaptionButton = new JButton();
                this.ivjcaptionButton.setName("captionButton");
                this.ivjcaptionButton.setToolTipText("Change the caption for this frame");
                this.ivjcaptionButton.setText("Change caption");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjcaptionButton;
    }

    private JPanel getcentrePanel() {
        if (this.ivjcentrePanel == null) {
            try {
                this.ivjcentrePanel = new JPanel();
                this.ivjcentrePanel.setName("centrePanel");
                this.ivjcentrePanel.setLayout(new BorderLayout());
                this.getcentrePanel().add((Component)this.getJScrollPane1(), "Center");
                this.getcentrePanel().add((Component)this.getcheckBoxPanel(), "South");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjcentrePanel;
    }

    private JPanel getcheckBoxPanel() {
        if (this.ivjcheckBoxPanel == null) {
            try {
                this.ivjcheckBoxPanel = new JPanel();
                this.ivjcheckBoxPanel.setName("checkBoxPanel");
                this.ivjcheckBoxPanel.setLayout(this.getcheckBoxPanelGridLayout());
                if (this.checkBoxes == null) {
                    this.checkBoxes = new JCheckBox[10];
                    int i = 0;
                    while (i < 10) {
                        this.checkBoxes[i] = new JCheckBox("Source " + i);
                        this.checkBoxes[i].setForeground(colors[i % colors.length]);
                        ++i;
                    }
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjcheckBoxPanel;
    }

    private GridLayout getcheckBoxPanelGridLayout() {
        GridLayout ivjcheckBoxPanelGridLayout = null;
        try {
            ivjcheckBoxPanelGridLayout = new GridLayout(1, 0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjcheckBoxPanelGridLayout;
    }

    private JButton getclearButton() {
        if (this.ivjclearButton == null) {
            try {
                this.ivjclearButton = new JButton();
                this.ivjclearButton.setName("clearButton");
                this.ivjclearButton.setToolTipText("Clears all the text in the window");
                this.ivjclearButton.setText("Clear");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjclearButton;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.ivjJScrollPane1.setHorizontalScrollBarPolicy(30);
                this.getJScrollPane1().setViewportView(this.getJTextPane1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JTextPane getJTextPane1() {
        if (this.ivjJTextPane1 == null) {
            try {
                this.ivjJTextPane1 = new JTextPane();
                this.ivjJTextPane1.setName("JTextPane1");
                this.ivjJTextPane1.setFont(new Font("monospaced", 0, 12));
                this.ivjJTextPane1.setBounds(0, 0, 11, 6);
                this.ivjJTextPane1.setEditable(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextPane1;
    }

    protected TitledBorder getMyBorder() {
        if (this.myBorder == null) {
            EtchedBorder b = new EtchedBorder(0);
            this.myBorder = new TitledBorder(b, " Connection #x from y ");
            this.myBorder.setTitleColor(Color.black);
            this.myBorder.setTitleJustification(2);
        }
        return this.myBorder;
    }

    private JButton getshutdownButton() {
        if (this.ivjshutdownButton == null) {
            try {
                this.ivjshutdownButton = new JButton();
                this.ivjshutdownButton.setName("shutdownButton");
                this.ivjshutdownButton.setToolTipText("Shuts down this connection");
                this.ivjshutdownButton.setText("Shutdown");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjshutdownButton;
    }

    public String getSourceName(int index) {
        try {
            return this.checkBoxes[index].getText();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTitle() {
        return this.getMyBorder().getTitle();
    }

    private void handleException(Throwable exception) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        exception.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getclearButton().addActionListener(this.ivjEventHandler);
        this.getshutdownButton().addActionListener(this.ivjEventHandler);
        this.getcaptionButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ConnectionDetailsPanel");
            this.setLayout(new BorderLayout());
            this.setSize(602, 409);
            this.add((Component)this.getcentrePanel(), "Center");
            this.add((Component)this.getbuttonPanel(), "South");
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setBorder(this.getMyBorder());
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            ConnectionDetailsPanel aConnectionDetailsPanel = new ConnectionDetailsPanel();
            frame.setContentPane(aConnectionDetailsPanel);
            frame.setSize(aConnectionDetailsPanel.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            exception.printStackTrace(System.out);
        }
    }

    public void setNumSources(int numSources) {
        if (numSources > 10) {
            numSources = 10;
        }
        int i = 0;
        while (i < numSources) {
            this.getcheckBoxPanel().remove(this.checkBoxes[i]);
            ++i;
        }
        this.numSources = numSources;
        i = 0;
        while (i < numSources) {
            this.getcheckBoxPanel().add(this.checkBoxes[i]);
            this.checkBoxes[i].setSelected(true);
            ++i;
        }
        this.getcentrePanel().revalidate();
        this.getcentrePanel().repaint();
    }

    public void setSourceName(int number, String name) {
        if (number < 0 || number > 9) {
            return;
        }
        this.checkBoxes[number].setText(name);
    }

    public void setTitle(String title) {
        this.getMyBorder().setTitle(title);
    }

    public void shutdown(final String message) {
        final Document d = this.getJTextPane1().getDocument();
        final SimpleAttributeSet s = sa[sa.length - 1];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectionDetailsPanel.this.getshutdownButton().setText("Remove");
                ConnectionDetailsPanel.this.getshutdownButton().setToolTipText("Remove this tab");
                ConnectionDetailsPanel.this.getclearButton().setEnabled(false);
                String inactive = "Inactive :";
                if (!ConnectionDetailsPanel.this.getTitle().startsWith(inactive)) {
                    ConnectionDetailsPanel.this.setTitle(String.valueOf(inactive) + ConnectionDetailsPanel.this.getTitle());
                }
                if (message != null) {
                    int pos = d.getLength();
                    try {
                        d.insertString(pos, message, s);
                    }
                    catch (BadLocationException e) {
                        System.out.println("oops : " + e);
                    }
                }
                ConnectionDetailsPanel.this.revalidate();
                ConnectionDetailsPanel.this.repaint();
            }
        });
    }

    public void shutdownButton_ActionPerformed(ActionEvent actionEvent) {
        if (this.getshutdownButton().getText().equalsIgnoreCase("shutdown")) {
            this.tws.shutdown();
            this.tws = null;
        } else {
            Container c = this.getParent();
            c.remove(this);
        }
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ConnectionDetailsPanel.this.getclearButton()) {
                ConnectionDetailsPanel.this.connEtoC1(e);
            }
            if (e.getSource() == ConnectionDetailsPanel.this.getshutdownButton()) {
                ConnectionDetailsPanel.this.connEtoC2(e);
            }
            if (e.getSource() == ConnectionDetailsPanel.this.getcaptionButton()) {
                ConnectionDetailsPanel.this.connEtoC4(e);
            }
        }
    }
}

