/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.Decoder;
import com.nickoh.snooper.PrintStreamProxy;
import com.nickoh.util.NickohLogHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleSnoop {
    private static final String moduleVersion = "2.0";
    private static Logger logger = NickohLogHandler.getLogger();
    private static Class[] decoders;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class[] classArray = new Class[5];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.nickoh.snooper.HexDecoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.nickoh.snooper.ASN1Decoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.nickoh.snooper.LDAPDecoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("com.nickoh.snooper.SSLDecoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("com.nickoh.snooper.RFC1006Decoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        decoders = classArray;
    }

    public static void main(String[] args) {
        System.out.println("ConsoleSnoop v2.0");
        if (args.length == 4) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.WARNING);
        }
        logger.log(Level.INFO, "ConsoleSnoop is initializing");
        if (args.length < 3) {
            System.out.println("Usage : java <prog> [server] [server-port] [listen-port] <trace>");
            return;
        }
        BufferedReader sysIn = new BufferedReader(new InputStreamReader(System.in));
        int decoderChoice = 0;
        try {
            String ans;
            do {
                System.out.println("Please choose decoder type (0 for exit) ");
                int i = 0;
                while (i < decoders.length) {
                    Class decoderClass = decoders[i];
                    Decoder d = (Decoder)decoderClass.newInstance();
                    String fullName = String.valueOf(d.getName()) + " " + d.getVersion();
                    System.out.println(i + 1 + " : " + fullName);
                    ++i;
                }
                System.out.println();
                System.out.print("Decoder ? ");
            } while ((decoderChoice = Integer.parseInt(ans = sysIn.readLine())) < 0 && decoderChoice > decoders.length);
        }
        catch (Exception ans) {
            // empty catch block
        }
        if (decoderChoice == 0) {
            return;
        }
        Class decoderClass = decoders[decoderChoice - 1];
        InetAddress server = null;
        PrintStreamProxy ps = null;
        try {
            server = InetAddress.getByName(args[0]);
            int serverPort = Integer.parseInt(args[1]);
            int listenPort = Integer.parseInt(args[2]);
            System.out.println("listening on " + listenPort + ", will redirect to " + args[0] + ":" + serverPort);
            ps = new PrintStreamProxy(server, serverPort, listenPort, decoderClass, System.out);
        }
        catch (Exception e) {
            System.out.println("failed to initialize, " + e);
            return;
        }
        Thread t = new Thread(ps);
        logger.info("starting proxyserver");
        t.setDaemon(true);
        t.start();
        System.out.println("Type ENTER to terminate the program : ");
        BufferedReader i = new BufferedReader(new InputStreamReader(System.in));
        try {
            i.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("ConsoleSnoop exiting");
    }
}

