/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.DecoderSink;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;

public abstract class Decoder {
    private static final String moduleVersion = "1.0";
    protected DecoderSink sink = null;
    protected String decoderName = null;
    private Date timestamp = null;
    public static final String dateFormatPattern = "dd-MMM-yyyy HH:mm:ss.SSS";
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS");

    public static final String byteToHex(byte param) {
        int i = param & 0xFF;
        String s = Integer.toString(i, 16);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s.toUpperCase();
    }

    public void close() {
        this.sink.close();
    }

    public abstract void decodeData(byte[] var1);

    public abstract void decodeData(byte[] var1, int var2);

    public synchronized void displayMessage(String s) {
        if (this.sink != null) {
            this.sink.sendToSink(s);
        }
    }

    public int getDefaultPort() {
        return -1;
    }

    public String getName() {
        return "Unnamed decoder";
    }

    public JPanel getOptionsPanel() {
        return null;
    }

    public static String getTimeNow() {
        return dateFormat.format(new Date());
    }

    public String getTimestamp() {
        if (this.timestamp == null) {
            return "";
        }
        return dateFormat.format(this.timestamp);
    }

    public String getVersion() {
        return moduleVersion;
    }

    public static final String makePrintable(String param) {
        if (param == null) {
            return null;
        }
        if (param.length() == 0) {
            return param;
        }
        char[] c = param.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (Character.isISOControl(c[i])) {
                c[i] = 46;
            }
            ++i;
        }
        return new String(c);
    }

    public void setName(String decoderName) {
        this.decoderName = decoderName;
    }

    public void setSink(DecoderSink sink) {
        this.sink = sink;
    }

    protected void setTimestamp() {
        this.timestamp = new Date();
    }
}

