/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.Decoder;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HexDecoder
extends Decoder {
    private static final String moduleVersion = "1.0";
    private static int optDumpStyle = 0;
    private static JPanel optionsPanel;
    public static final int DS_CLASSIC = 0;
    public static final int DS_X500DUMP = 1;
    private static JComboBox optionsCombo;

    static {
        optionsCombo = null;
    }

    public void decodeData(byte[] byteArray) {
        this.decodeData(byteArray, byteArray.length);
    }

    public synchronized void decodeData(byte[] byteArray, int length) {
        this.setTimestamp();
        this.displayMessage(String.valueOf(this.getTimestamp()) + " : " + this.decoderName + "\n  ");
        String s = HexDecoder.hexify(byteArray, length);
        this.displayMessage(s);
        this.displayMessage("\n\n");
    }

    private static String dsaHexify(byte[] byteArray, int startPos, int length, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String eol = "\n";
        String retval = "";
        if (length == 0) {
            return "";
        }
        int lastOffset = startPos + length;
        int offset = startPos;
        while (offset < lastOffset) {
            String hexvals = "";
            String ascii = "";
            int i = 0;
            while (i < 16) {
                int byteOffset = offset + i;
                if (byteOffset < lastOffset) {
                    hexvals = String.valueOf(hexvals) + Decoder.byteToHex(byteArray[byteOffset]) + " ";
                    char c = (char)(byteArray[byteOffset] & 0x7F);
                    if (Character.isISOControl(c)) {
                        c = ' ';
                    }
                    ascii = String.valueOf(ascii) + c;
                } else {
                    hexvals = String.valueOf(hexvals) + "   ";
                }
                ++i;
            }
            retval = String.valueOf(retval) + "\n" + prefix + hexvals.toLowerCase() + "   " + ascii;
            offset += 16;
        }
        return String.valueOf(retval) + "\n";
    }

    public String getName() {
        return "Simple Hex Decoder";
    }

    public synchronized JPanel getOptionsPanel() {
        if (optionsPanel != null) {
            return optionsPanel;
        }
        JLabel dsLabel = new JLabel("Dump style");
        optionsCombo = new JComboBox();
        optionsCombo.addItem("Classic");
        optionsCombo.addItem("X.500 diagnostic trace");
        optionsCombo.setSelectedIndex(optDumpStyle);
        optionsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                optDumpStyle = optionsCombo.getSelectedIndex();
            }
        });
        optionsPanel = new JPanel(new FlowLayout());
        optionsPanel.add(dsLabel);
        optionsPanel.add(optionsCombo);
        return optionsPanel;
    }

    public String getVersion() {
        return moduleVersion;
    }

    public static String hexify(byte[] byteArray) {
        return HexDecoder.hexify(byteArray, 0, byteArray.length);
    }

    public static String hexify(byte[] byteArray, int length) {
        return HexDecoder.hexify(byteArray, 0, length);
    }

    public static String hexify(byte[] byteArray, int startPos, int length) {
        return HexDecoder.hexify(byteArray, startPos, length, "");
    }

    public static String hexify(byte[] byteArray, int startPos, int length, String prefix) {
        if (optDumpStyle == 1) {
            return HexDecoder.dsaHexify(byteArray, startPos, length, prefix);
        }
        if (prefix == null) {
            prefix = "";
        }
        String eol = "\n";
        String newLine = "\n" + prefix;
        String hex = "";
        String ascii = "";
        String result = prefix;
        if (length == 0) {
            return "";
        }
        int i = 0;
        while (i < length) {
            if (i % 16 == 0) {
                if (i > 0) {
                    result = String.valueOf(result) + newLine + ascii + newLine + hex + newLine;
                    hex = null;
                    ascii = null;
                }
                String offset = "0000" + Integer.toHexString(i);
                offset = offset.substring(offset.length() - 4, offset.length());
                ascii = hex = String.valueOf(offset) + " : ";
            }
            hex = String.valueOf(hex) + Decoder.byteToHex(byteArray[i + startPos]) + "  ";
            char c = (char)(byteArray[i + startPos] & 0x7F);
            if (Character.isISOControl(c)) {
                c = '.';
            }
            ascii = String.valueOf(ascii) + " " + c + "  ";
            ++i;
        }
        if (hex != null) {
            result = String.valueOf(result) + newLine + ascii + newLine + hex + newLine;
        }
        result = String.valueOf(result) + "\n";
        return result;
    }

    public static String hexify(byte[] byteArray, int length, String prefix) {
        return HexDecoder.hexify(byteArray, 0, length, prefix);
    }

    public static String hexify(byte[] byteArray, String prefix) {
        return HexDecoder.hexify(byteArray, 0, byteArray.length, prefix);
    }

    public static void setDumpStyle(int dumpStyle) {
        if (dumpStyle == 0 || dumpStyle == 1) {
            optDumpStyle = dumpStyle;
            if (optionsCombo != null) {
                optionsCombo.setSelectedIndex(optDumpStyle);
            }
        }
    }
}

