/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.asn.BerUtilities;
import com.nickoh.snooper.ASN1Decoder;
import com.nickoh.snooper.Decoder;
import com.nickoh.snooper.SSLDecoder;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class LDAPDecoder
extends ASN1Decoder {
    private static final String moduleVersion = "1.0";
    public static final byte bindRequestTag = 0;
    public static final byte bindResponseTag = 1;
    public static final byte unbindRequestTag = 2;
    public static final byte searchRequestTag = 3;
    public static final byte searchResultEntryTag = 4;
    public static final byte searchResultDoneTag = 5;
    public static final byte searchResultReferenceTag = 19;
    public static final byte modifyRequestTag = 6;
    public static final byte modifyResponseTag = 7;
    public static final byte addRequestTag = 8;
    public static final byte addResponseTag = 9;
    public static final byte delRequestTag = 10;
    public static final byte delResponseTag = 11;
    public static final byte modifyDNRequestTag = 12;
    public static final byte modifyDNResponseTag = 13;
    public static final byte compareRequestTag = 14;
    public static final byte compareResponseTag = 15;
    public static final byte abandonRequestTag = 16;
    public static final byte extendedRequestTag = 23;
    public static final byte extendedResponseTag = 24;
    public static final int LDAP_SUCCESS = 0;
    public static final int LDAP_OPERATIONS_ERROR = 1;
    public static final int LDAP_PROTOCOL_ERROR = 2;
    public static final int LDAP_TIMELIMIT_EXCEEDED = 3;
    public static final int LDAP_SIZELIMIT_EXCEEDED = 4;
    public static final int LDAP_COMPARE_FALSE = 5;
    public static final int LDAP_COMPARE_TRUE = 6;
    public static final int LDAP_STRONG_AUTH_NOT_SUPPORTED = 7;
    public static final int LDAP_STRONG_AUTH_REQUIRED = 8;
    public static final int LDAP_PARTIAL_RESULTS = 9;
    public static final int LDAP_REFERRAL = 10;
    public static final int LDAP_ADMIN_LIMIT_EXCEEDED = 11;
    public static final int LDAP_UNAVAILABLE_CRITICAL_EXTENSION = 12;
    public static final int LDAP_CONFIDENTIALITY_REQUIRED = 13;
    public static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    public static final int LDAP_NO_SUCH_ATTRIBUTE = 16;
    public static final int LDAP_UNDEFINED_TYPE = 17;
    public static final int LDAP_INAPPROPRIATE_MATCHING = 18;
    public static final int LDAP_CONSTRAINT_VIOLATION = 19;
    public static final int LDAP_TYPE_OR_VALUE_EXISTS = 20;
    public static final int LDAP_INVALID_SYNTAX = 21;
    public static final int LDAP_NO_SUCH_OBJECT = 32;
    public static final int LDAP_ALIAS_PROBLEM = 33;
    public static final int LDAP_INVALID_DN_SYNTAX = 34;
    public static final int LDAP_IS_LEAF = 35;
    public static final int LDAP_ALIAS_DEREF_PROBLEM = 36;
    public static final int LDAP_INAPPROPRIATE_AUTH = 48;
    public static final int LDAP_INVALID_CREDENTIALS = 49;
    public static final int LDAP_INSUFFICIENT_ACCESS = 50;
    public static final int LDAP_BUSY = 51;
    public static final int LDAP_UNAVAILABLE = 52;
    public static final int LDAP_UNWILLING_TO_PERFORM = 53;
    public static final int LDAP_LOOP_DETECT = 54;
    public static final int LDAP_SORT_CONTROL_MISSING = 60;
    public static final int LDAP_INDEX_RANGE_ERROR = 61;
    public static final int LDAP_NAMING_VIOLATION = 64;
    public static final int LDAP_OBJECT_CLASS_VIOLATION = 65;
    public static final int LDAP_NOT_ALLOWED_ON_NONLEAF = 66;
    public static final int LDAP_NOT_ALLOWED_ON_RDN = 67;
    public static final int LDAP_ALREADY_EXISTS = 68;
    public static final int LDAP_NO_OBJECT_CLASS_MODS = 69;
    public static final int LDAP_RESULTS_TOO_LARGE = 70;
    public static final int LDAP_AFFECTS_MULTIPLE_DSAS = 71;
    public static final int LDAP_OTHER = 80;
    private SSLDecoder sslDecoder = null;
    public static final String tlsRequested = "  ***** TLS REQUESTED *****";
    public static final String tlsStarted = "  ***** TLS started *****";
    private boolean clientRequestedTls = false;
    public static final String errorPrefix = "Error : ";
    private static boolean optDecodeSREAttributes = true;
    private JPanel optionsPanel = null;
    private static boolean optAbbreviatedSearchDecode = false;

    protected void checkForCompleteMessage() {
        while (this.cache.size() >= 2) {
            byte[] message = this.cache.toByteArray();
            int lenLength = 1;
            if (message[1] <= 0) {
                lenLength = message[1] + 129;
            }
            if (message.length < 1 + lenLength) {
                return;
            }
            int realMessageLength = BerUtilities.getComponentLength(message, 0);
            if (realMessageLength == -1) {
                if (this.clientRequestedTls) {
                    this.switchToSSL();
                } else {
                    this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n *** Invalid length field found.  Message discarded. ***\n");
                    this.cache.reset();
                }
                return;
            }
            if (realMessageLength > message.length) {
                return;
            }
            String humanReadable = LDAPDecoder.decodeLDAPMessage(message);
            if (humanReadable.startsWith(errorPrefix) && this.clientRequestedTls) {
                this.switchToSSL();
                return;
            }
            this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n");
            this.displayMessage(String.valueOf(humanReadable) + "\n");
            this.cache.reset();
            if (realMessageLength < message.length) {
                this.cache.write(message, realMessageLength, message.length - realMessageLength);
            }
            if (humanReadable.indexOf(tlsStarted) != -1) {
                this.switchToSSL();
            }
            if (humanReadable.indexOf(tlsRequested) == -1) continue;
            this.clientRequestedTls = true;
        }
        return;
    }

    public static String decodeAbandonRequest(byte[] message, int tagOffset) {
        String retval = "Abandon Request {\n";
        retval = String.valueOf(retval) + "  Message ID   : " + BerUtilities.getInteger(message, tagOffset) + "\n";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeAddRequest(byte[] message, int tagOffset) {
        String retval = "Add Request {\n";
        int entryOffset = BerUtilities.dataOffset(message, tagOffset);
        int entryLen = BerUtilities.getComponentLength(message, entryOffset);
        int attributesOffset = entryOffset + entryLen;
        retval = String.valueOf(retval) + "  Entry        : " + BerUtilities.getString(message, entryOffset) + "\n";
        retval = String.valueOf(retval) + "  attributes   : {\n";
        String prefix = "                   ";
        retval = String.valueOf(retval) + LDAPDecoder.decodeAttributeList(message, attributesOffset, prefix);
        retval = String.valueOf(retval) + "                 }\n";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeAddResponse(byte[] message, int tagOffset) {
        String retval = "Add Response {\n";
        int resultComponentsOffset = BerUtilities.dataOffset(message, tagOffset);
        retval = String.valueOf(retval) + LDAPDecoder.decodeLDAPResultComponents(message, resultComponentsOffset, 4);
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeAttributeList(byte[] message, int startOffset, String prefix) {
        String retval = "";
        int attributesLen = BerUtilities.getComponentLength(message, startOffset);
        int attributesListEnd = startOffset + attributesLen;
        int attributeOffset = BerUtilities.dataOffset(message, startOffset);
        while (attributeOffset < attributesListEnd) {
            int attributeLen = BerUtilities.getComponentLength(message, attributeOffset);
            int typeOffset = BerUtilities.dataOffset(message, attributeOffset);
            int typeLen = BerUtilities.getComponentLength(message, typeOffset);
            int setOffset = typeOffset + typeLen;
            String attr = String.valueOf(prefix) + BerUtilities.getString(message, typeOffset) + ":";
            int setLen = BerUtilities.getComponentLength(message, setOffset);
            int setEnd = setOffset + setLen;
            int valueOffset = BerUtilities.dataOffset(message, setOffset);
            if (valueOffset >= setEnd) {
                retval = String.valueOf(retval) + attr + "<zero-length value returned>\n";
            }
            while (valueOffset < setEnd) {
                int valueLen = BerUtilities.getComponentLength(message, valueOffset);
                retval = String.valueOf(retval) + attr + Decoder.makePrintable(BerUtilities.getString(message, valueOffset)) + "\n";
                valueOffset += valueLen;
            }
            attributeOffset += attributeLen;
        }
        return retval;
    }

    public static String decodeBindRequest(byte[] message, int tagOffset) {
        String retval = "Bind Request {\n";
        int offset = BerUtilities.dataOffset(message, tagOffset);
        int version = BerUtilities.getInteger(message, offset);
        offset += BerUtilities.getComponentLength(message, offset);
        String name = BerUtilities.getString(message, offset);
        offset += BerUtilities.getComponentLength(message, offset);
        String authenticationChoice = "";
        byte choice = (byte)(message[offset] & 0x1F);
        switch (choice) {
            case 0: {
                authenticationChoice = "simple : ";
                authenticationChoice = String.valueOf(authenticationChoice) + "\"" + BerUtilities.getString(message, offset) + "\"";
                break;
            }
            case 3: {
                authenticationChoice = "sasl, not decoded";
                break;
            }
            default: {
                authenticationChoice = "invalid value #" + choice;
            }
        }
        retval = String.valueOf(retval) + "  version        : " + version + "\n";
        retval = String.valueOf(retval) + "  name           : " + name + "\n";
        retval = String.valueOf(retval) + "  authentication : " + authenticationChoice + "\n";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeBindResponse(byte[] message, int tagOffset) {
        String retval = "Bind Response {\n";
        int offset = BerUtilities.dataOffset(message, tagOffset);
        retval = String.valueOf(retval) + LDAPDecoder.decodeLDAPResultComponents(message, offset, 4);
        byte tag = -121;
        int saslCredsOffset = BerUtilities.tagOffset(message, tag, offset);
        if (saslCredsOffset != -1) {
            retval = String.valueOf(retval) + "    serverSaslCreds = " + BerUtilities.getString(message, saslCredsOffset) + "\n";
        }
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeCompareRequest(byte[] message, int tagOffset) {
        String retval = "Compare Request {\n";
        int entryOffset = BerUtilities.dataOffset(message, tagOffset);
        int entryLen = BerUtilities.getComponentLength(message, entryOffset);
        int avaOffset = entryOffset + entryLen;
        int avaLen = BerUtilities.getComponentLength(message, avaOffset);
        retval = String.valueOf(retval) + "  entry        : " + BerUtilities.getString(message, entryOffset) + "\n";
        int attributeDescOffset = BerUtilities.dataOffset(message, avaOffset);
        int attributeDescLen = BerUtilities.getComponentLength(message, avaOffset);
        int assertionValueOffset = attributeDescOffset + attributeDescLen;
        retval = String.valueOf(retval) + "  ava          : " + BerUtilities.getString(message, attributeDescOffset) + "=" + BerUtilities.getString(message, assertionValueOffset) + "\n";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeCompareResponse(byte[] message, int tagOffset) {
        String retval = "Compare Response {\n";
        int resultComponentsOffset = BerUtilities.dataOffset(message, tagOffset);
        retval = String.valueOf(retval) + LDAPDecoder.decodeLDAPResultComponents(message, resultComponentsOffset, 4);
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public synchronized void decodeData(byte[] byteArray, int length) {
        if (this.sslDecoder != null) {
            this.sslDecoder.decodeData(byteArray, length);
            return;
        }
        if (this.cache.size() == 0) {
            this.setTimestamp();
        }
        this.cache.write(byteArray, 0, length);
        this.checkForCompleteMessage();
    }

    public static String decodeDelRequest(byte[] message, int tagOffset) {
        String retval = "Delete Request {\n";
        retval = String.valueOf(retval) + "  DN           : " + BerUtilities.getString(message, tagOffset) + "\n";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeDelResponse(byte[] message, int tagOffset) {
        String retval = "Delete Response {\n";
        int resultComponentsOffset = BerUtilities.dataOffset(message, tagOffset);
        retval = String.valueOf(retval) + LDAPDecoder.decodeLDAPResultComponents(message, resultComponentsOffset, 4);
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeExtendedRequest(byte[] message, int tagOffset) {
        String retval = "Extended Request {\n";
        byte tag = -128;
        int offset = BerUtilities.dataOffset(message, tagOffset);
        int oidOffset = BerUtilities.tagOffset(message, tag, offset);
        if (oidOffset == -1) {
            retval = String.valueOf(retval) + " ** invalid contents, can't find tag [0] ** \n}\n";
            return retval;
        }
        String oid = BerUtilities.getString(message, oidOffset);
        oid = LDAPDecoder.getOidDesc(oid);
        retval = String.valueOf(retval) + "  requestName  : " + oid;
        if (oid.indexOf("1.3.6.1.4.1.1466.20037") != -1) {
            retval = String.valueOf(retval) + tlsRequested;
        }
        retval = String.valueOf(retval) + "\n";
        tag = -127;
        int valOffset = BerUtilities.tagOffset(message, tag, offset);
        retval = valOffset != -1 ? String.valueOf(retval) + "  requestValue : " + BerUtilities.getString(message, valOffset) + "\n" : String.valueOf(retval) + "                 (no associated value)\n";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeExtendedResponse(byte[] message, int tagOffset) {
        boolean tls = false;
        String retval = "Extended Response {\n";
        int offset = BerUtilities.dataOffset(message, tagOffset);
        retval = String.valueOf(retval) + LDAPDecoder.decodeLDAPResultComponents(message, offset, 4);
        byte tag = -118;
        int oidOffset = BerUtilities.tagOffset(message, tag, offset);
        if (oidOffset != -1) {
            String oid = BerUtilities.getString(message, oidOffset);
            if (oid.equalsIgnoreCase("1.3.6.1.4.1.1466.20037") && retval.indexOf("LDAP_SUCCESS") != -1) {
                tls = true;
            }
            oid = LDAPDecoder.getOidDesc(oid);
            retval = String.valueOf(retval) + "  responseName  : " + oid + (tls ? tlsStarted : null) + "\n";
        } else {
            retval = String.valueOf(retval) + "  responseName  : (not supplied)\n";
        }
        tag = -117;
        int valOffset = BerUtilities.tagOffset(message, tag, offset);
        retval = valOffset != -1 ? String.valueOf(retval) + "  response      : " + BerUtilities.getString(message, valOffset) + "\n" : String.valueOf(retval) + "  response      : (not supplied)\n";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeLDAPMessage(byte[] message) {
        String retval = "";
        boolean clientAskedForTls = false;
        boolean serverAgreedTls = false;
        try {
            byte tag = message[0];
            if (tag != 48) {
                return "Error : Message doesn't start with LBER_SEQUENCE";
            }
            int messageLength = BerUtilities.getComponentLength(message, 0);
            int idOffset = BerUtilities.dataOffset(message, 0);
            int idLength = BerUtilities.getComponentLength(message, idOffset);
            int messageID = BerUtilities.getInteger(message, idOffset);
            retval = "====LDAP Message id #" + messageID + " {\n";
            int protocolOpOffset = idOffset + idLength;
            int protocolOpLength = BerUtilities.getComponentLength(message, protocolOpOffset);
            if (protocolOpLength + protocolOpOffset > message.length) {
                return errorPrefix + retval + "---indicated length (" + protocolOpLength + ") too large\n";
            }
            int controlsOffset = protocolOpOffset + protocolOpLength;
            byte operationTag = message[protocolOpOffset];
            if ((operationTag & 0x40) == 0) {
                return errorPrefix + retval + "---tag for protocolOp was not APPLICATION (value was 0x" + BerUtilities.byteToHex(operationTag) + ")\n";
            }
            byte operationType = (byte)(operationTag & 0x1F);
            switch (operationType) {
                case 0: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeBindRequest(message, protocolOpOffset);
                    break;
                }
                case 1: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeBindResponse(message, protocolOpOffset);
                    break;
                }
                case 2: {
                    retval = String.valueOf(retval) + "UnbindRequest {\n}\n";
                    break;
                }
                case 3: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeSearchRequest(message, protocolOpOffset);
                    break;
                }
                case 4: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeSearchResultEntry(message, protocolOpOffset);
                    break;
                }
                case 5: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeSearchResultDone(message, protocolOpOffset);
                    break;
                }
                case 19: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeSearchResultReference(message, protocolOpOffset);
                    break;
                }
                case 6: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeModifyRequest(message, protocolOpOffset);
                    break;
                }
                case 7: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeModifyResponse(message, protocolOpOffset);
                    break;
                }
                case 8: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeAddRequest(message, protocolOpOffset);
                    break;
                }
                case 9: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeAddResponse(message, protocolOpOffset);
                    break;
                }
                case 10: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeDelRequest(message, protocolOpOffset);
                    break;
                }
                case 11: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeDelResponse(message, protocolOpOffset);
                    break;
                }
                case 12: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeModifyDNRequest(message, protocolOpOffset);
                    break;
                }
                case 13: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeModifyDNResponse(message, protocolOpOffset);
                    break;
                }
                case 14: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeCompareRequest(message, protocolOpOffset);
                    break;
                }
                case 15: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeCompareResponse(message, protocolOpOffset);
                    break;
                }
                case 16: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeAbandonRequest(message, protocolOpOffset);
                    break;
                }
                case 23: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeExtendedRequest(message, protocolOpOffset);
                    if (!retval.endsWith(tlsRequested)) break;
                    clientAskedForTls = true;
                    break;
                }
                case 24: {
                    retval = String.valueOf(retval) + LDAPDecoder.decodeExtendedResponse(message, protocolOpOffset);
                    if (!retval.endsWith(tlsStarted)) break;
                    serverAgreedTls = true;
                    break;
                }
                default: {
                    retval = errorPrefix + retval + "--- unrecognized operation : 0x" + BerUtilities.byteToHex(operationTag) + "\n";
                }
            }
            tag = -96;
            int controlsSequenceOffset = BerUtilities.tagOffset(message, tag, idOffset);
            if (controlsSequenceOffset != -1) {
                int controlOffset = BerUtilities.dataOffset(message, controlsSequenceOffset);
                int numControls = 0;
                while (controlOffset < messageLength) {
                    int seqLen = BerUtilities.getComponentLength(message, controlOffset);
                    int controlTypeOffset = BerUtilities.dataOffset(message, controlOffset);
                    int controlTypeLen = BerUtilities.getComponentLength(message, controlTypeOffset);
                    String controlType = BerUtilities.getString(message, controlTypeOffset);
                    controlType = LDAPDecoder.getOidDesc(controlType);
                    int criticalityOffset = controlTypeOffset + controlTypeLen;
                    boolean criticality = false;
                    int controlValueOffset = criticalityOffset;
                    String controlValue = "";
                    if (criticalityOffset < messageLength) {
                        if (message[criticalityOffset] == 1) {
                            criticality = BerUtilities.getInteger(message, criticalityOffset) != 0;
                            controlValueOffset = criticalityOffset + BerUtilities.getComponentLength(message, criticalityOffset);
                        }
                        if (controlValueOffset < controlOffset + seqLen) {
                            controlValue = BerUtilities.getString(message, controlValueOffset);
                        }
                    }
                    retval = String.valueOf(retval) + "  Control #" + ++numControls + " {\n";
                    retval = String.valueOf(retval) + "     controlType = " + controlType + "\n";
                    retval = String.valueOf(retval) + "     criticality = " + criticality + "\n";
                    retval = String.valueOf(retval) + "     controlVal  = \"" + controlValue + "\"\n";
                    retval = String.valueOf(retval) + "  }\n";
                    controlOffset += seqLen;
                }
            }
            retval = String.valueOf(retval) + "}\n";
        }
        catch (IndexOutOfBoundsException e) {
            retval = "Error : Array index out of bounds, possible invalid LDAP message\n";
            retval = String.valueOf(retval) + "ASN1 decode gives : " + ASN1Decoder.decodeTLV(message, 0, BerUtilities.getComponentLength(message, 0), 4);
        }
        return retval;
    }

    public static String decodeLDAPResultComponents(byte[] message, int resultOffset, int indentation) {
        int resultCode = BerUtilities.getInteger(message, resultOffset);
        int resultLen = BerUtilities.getComponentLength(message, resultOffset);
        int matchedDNOffset = resultOffset + resultLen;
        int matchedDNLen = BerUtilities.getComponentLength(message, matchedDNOffset);
        int errorMessageOffset = matchedDNOffset + matchedDNLen;
        int errorMessageLen = BerUtilities.getComponentLength(message, errorMessageOffset);
        String prefix = "";
        int i = 0;
        while (i < indentation) {
            prefix = String.valueOf(prefix) + " ";
            ++i;
        }
        String retval = String.valueOf(prefix) + "LDAPResult {\n" + prefix + "  resultCode = ";
        switch (resultCode) {
            case 0: {
                retval = String.valueOf(retval) + "LDAP_SUCCESS";
                break;
            }
            case 1: {
                retval = String.valueOf(retval) + "LDAP_OPERATIONS_ERROR";
                break;
            }
            case 2: {
                retval = String.valueOf(retval) + "LDAP_PROTOCOL_ERROR";
                break;
            }
            case 3: {
                retval = String.valueOf(retval) + "LDAP_TIMELIMIT_EXCEEDED";
                break;
            }
            case 4: {
                retval = String.valueOf(retval) + "LDAP_SIZELIMIT_EXCEEDED";
                break;
            }
            case 5: {
                retval = String.valueOf(retval) + "LDAP_COMPARE_FALSE";
                break;
            }
            case 6: {
                retval = String.valueOf(retval) + "LDAP_COMPARE_TRUE";
                break;
            }
            case 7: {
                retval = String.valueOf(retval) + "LDAP_STRONG_AUTH_NOT_SUPPORTED";
                break;
            }
            case 8: {
                retval = String.valueOf(retval) + "LDAP_STRONG_AUTH_REQUIRED";
                break;
            }
            case 9: {
                retval = String.valueOf(retval) + "LDAP_PARTIAL_RESULTS";
                break;
            }
            case 10: {
                retval = String.valueOf(retval) + "LDAP_REFERRAL";
                break;
            }
            case 11: {
                retval = String.valueOf(retval) + "LDAP_ADMIN_LIMIT_EXCEEDED";
                break;
            }
            case 12: {
                retval = String.valueOf(retval) + "LDAP_UNAVAILABLE_CRITICAL_EXTENSION";
                break;
            }
            case 13: {
                retval = String.valueOf(retval) + "LDAP_CONFIDENTIALITY_REQUIRED";
                break;
            }
            case 14: {
                retval = String.valueOf(retval) + "LDAP_SASL_BIND_IN_PROGRESS";
                break;
            }
            case 16: {
                retval = String.valueOf(retval) + "LDAP_NO_SUCH_ATTRIBUTE";
                break;
            }
            case 17: {
                retval = String.valueOf(retval) + "LDAP_UNDEFINED_TYPE";
                break;
            }
            case 18: {
                retval = String.valueOf(retval) + "LDAP_INAPPROPRIATE_MATCHING";
                break;
            }
            case 19: {
                retval = String.valueOf(retval) + "LDAP_CONSTRAINT_VIOLATION";
                break;
            }
            case 20: {
                retval = String.valueOf(retval) + "LDAP_TYPE_OR_VALUE_EXISTS";
                break;
            }
            case 21: {
                retval = String.valueOf(retval) + "LDAP_INVALID_SYNTAX";
                break;
            }
            case 32: {
                retval = String.valueOf(retval) + "LDAP_NO_SUCH_OBJECT";
                break;
            }
            case 33: {
                retval = String.valueOf(retval) + "LDAP_ALIAS_PROBLEM";
                break;
            }
            case 34: {
                retval = String.valueOf(retval) + "LDAP_INVALID_DN_SYNTAX";
                break;
            }
            case 35: {
                retval = String.valueOf(retval) + "LDAP_IS_LEAF";
                break;
            }
            case 36: {
                retval = String.valueOf(retval) + "LDAP_ALIAS_DEREF_PROBLEM";
                break;
            }
            case 48: {
                retval = String.valueOf(retval) + "LDAP_INAPPROPRIATE_AUTH";
                break;
            }
            case 49: {
                retval = String.valueOf(retval) + "LDAP_INVALID_CREDENTIALS";
                break;
            }
            case 50: {
                retval = String.valueOf(retval) + "LDAP_INSUFFICIENT_ACCESS";
                break;
            }
            case 51: {
                retval = String.valueOf(retval) + "LDAP_BUSY";
                break;
            }
            case 52: {
                retval = String.valueOf(retval) + "LDAP_UNAVAILABLE";
                break;
            }
            case 53: {
                retval = String.valueOf(retval) + "LDAP_UNWILLING_TO_PERFORM";
                break;
            }
            case 54: {
                retval = String.valueOf(retval) + "LDAP_LOOP_DETECT";
                break;
            }
            case 60: {
                retval = String.valueOf(retval) + "LDAP_SORT_CONTROL_MISSING";
                break;
            }
            case 61: {
                retval = String.valueOf(retval) + "LDAP_INDEX_RANGE_ERROR";
                break;
            }
            case 64: {
                retval = String.valueOf(retval) + "LDAP_NAMING_VIOLATION";
                break;
            }
            case 65: {
                retval = String.valueOf(retval) + "LDAP_OBJECT_CLASS_VIOLATION";
                break;
            }
            case 66: {
                retval = String.valueOf(retval) + "LDAP_NOT_ALLOWED_ON_NONLEAF";
                break;
            }
            case 67: {
                retval = String.valueOf(retval) + "LDAP_NOT_ALLOWED_ON_RDN";
                break;
            }
            case 68: {
                retval = String.valueOf(retval) + "LDAP_ALREADY_EXISTS";
                break;
            }
            case 69: {
                retval = String.valueOf(retval) + "LDAP_NO_OBJECT_CLASS_MODS";
                break;
            }
            case 70: {
                retval = String.valueOf(retval) + "LDAP_RESULTS_TOO_LARGE";
                break;
            }
            case 71: {
                retval = String.valueOf(retval) + "LDAP_AFFECTS_MULTIPLE_DSAS";
                break;
            }
            case 80: {
                retval = String.valueOf(retval) + "LDAP_OTHER";
                break;
            }
            default: {
                retval = String.valueOf(retval) + "unknown error code";
            }
        }
        retval = String.valueOf(retval) + " (" + resultCode + ")\n";
        retval = String.valueOf(retval) + prefix + "  matchedDN    = \"" + BerUtilities.getString(message, matchedDNOffset) + "\"\n";
        retval = String.valueOf(retval) + prefix + "  errorMessage = \"" + BerUtilities.getString(message, errorMessageOffset) + "\"\n";
        retval = String.valueOf(retval) + prefix + "}\n";
        return retval;
    }

    public static String decodeModifyDNRequest(byte[] message, int tagOffset) {
        String retval = "ModifyDN Request {\n";
        int entryOffset = BerUtilities.dataOffset(message, tagOffset);
        int entryLen = BerUtilities.getComponentLength(message, entryOffset);
        int newrdnOffset = entryOffset + entryLen;
        int newrdnLen = BerUtilities.getComponentLength(message, newrdnOffset);
        int deleteoldrdnOffset = newrdnOffset + newrdnLen;
        int deleteoldrdnLen = BerUtilities.getComponentLength(message, deleteoldrdnOffset);
        byte tag = -128;
        int newSuperiorOffset = BerUtilities.tagOffset(message, tag, entryOffset);
        retval = String.valueOf(retval) + "  entry        : " + BerUtilities.getString(message, entryOffset) + "\n";
        retval = String.valueOf(retval) + "  newrdn       : " + BerUtilities.getString(message, newrdnOffset) + "\n";
        retval = String.valueOf(retval) + "  deleteoldrdn : " + BerUtilities.getString(message, deleteoldrdnOffset) + "\n";
        String newSuperior = "<not specified>";
        if (newSuperiorOffset != -1) {
            newSuperior = BerUtilities.getString(message, newSuperiorOffset);
        }
        retval = String.valueOf(retval) + "  newSuperior  : " + newSuperior + "\n";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeModifyDNResponse(byte[] message, int tagOffset) {
        String retval = "ModifyDN Response {\n";
        int resultComponentsOffset = BerUtilities.dataOffset(message, tagOffset);
        retval = String.valueOf(retval) + LDAPDecoder.decodeLDAPResultComponents(message, resultComponentsOffset, 4);
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeModifyRequest(byte[] message, int tagOffset) {
        String retval = "Modify Request {\n";
        int objectOffset = BerUtilities.dataOffset(message, tagOffset);
        int objectLen = BerUtilities.getComponentLength(message, objectOffset);
        int modificationSeqSeqOffset = objectOffset + objectLen;
        int modificationSeqSeqLen = BerUtilities.getComponentLength(message, modificationSeqSeqOffset);
        int modSeqSeqEnd = modificationSeqSeqOffset + modificationSeqSeqLen;
        retval = String.valueOf(retval) + "  object       : " + BerUtilities.getString(message, objectOffset) + "\n";
        retval = String.valueOf(retval) + "  modifications:\n";
        String prefix = "                   ";
        int modificationNumber = 0;
        int seqOffset = BerUtilities.dataOffset(message, modificationSeqSeqOffset);
        while (seqOffset < modSeqSeqEnd) {
            int seqLen = BerUtilities.getComponentLength(message, seqOffset);
            int seqEnd = seqOffset + seqLen;
            ++modificationNumber;
            retval = String.valueOf(retval) + prefix + " {\n";
            int operationOffset = BerUtilities.dataOffset(message, seqOffset);
            int operationLen = BerUtilities.getComponentLength(message, operationOffset);
            int opType = BerUtilities.getInteger(message, operationOffset);
            int atvOffset = operationOffset + operationLen;
            int atvLen = BerUtilities.getComponentLength(message, atvOffset);
            int atvEnd = atvOffset + atvLen;
            int typeOffset = BerUtilities.dataOffset(message, atvOffset);
            int typeLen = BerUtilities.getComponentLength(message, typeOffset);
            String attrName = BerUtilities.getString(message, typeOffset);
            int valsOffset = typeOffset + typeLen;
            int valsLen = BerUtilities.getComponentLength(message, valsOffset);
            int valsEnd = valsOffset + valsLen;
            String attrVals = "";
            int oneValueOffset = BerUtilities.dataOffset(message, valsOffset);
            while (oneValueOffset < valsEnd) {
                int oneValueLen = BerUtilities.getComponentLength(message, oneValueOffset);
                attrVals = String.valueOf(attrVals) + BerUtilities.getString(message, oneValueOffset) + " ";
                oneValueOffset += oneValueLen;
            }
            switch (opType) {
                case 0: {
                    retval = String.valueOf(retval) + prefix + "   add     : ";
                    break;
                }
                case 1: {
                    retval = String.valueOf(retval) + prefix + "   delete  : ";
                    break;
                }
                case 2: {
                    retval = String.valueOf(retval) + prefix + "   replace : ";
                    break;
                }
                default: {
                    retval = String.valueOf(retval) + prefix + "   (illegal operation code : #" + opType + ") : ";
                }
            }
            retval = String.valueOf(retval) + attrName + "=" + Decoder.makePrintable(attrVals) + "\n";
            retval = String.valueOf(retval) + prefix + " }\n";
            seqOffset += seqLen;
        }
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeModifyResponse(byte[] message, int tagOffset) {
        String retval = "Modify Response {\n";
        int resultComponentsOffset = BerUtilities.dataOffset(message, tagOffset);
        retval = String.valueOf(retval) + LDAPDecoder.decodeLDAPResultComponents(message, resultComponentsOffset, 4);
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeSearchFilter(byte[] message, int tagOffset) {
        String eol = "\n";
        String retval = "";
        byte choice = (byte)(message[tagOffset] & 0x1F);
        switch (choice) {
            case 0: {
                int setLength = BerUtilities.getComponentLength(message, tagOffset);
                int setEnd = tagOffset + setLength;
                boolean firstFilterDone = false;
                retval = "(";
                int filterOffset = BerUtilities.dataOffset(message, tagOffset);
                while (filterOffset < setEnd) {
                    int filterLen = BerUtilities.getComponentLength(message, filterOffset);
                    if (firstFilterDone) {
                        retval = String.valueOf(retval) + " AND ";
                    } else {
                        firstFilterDone = true;
                    }
                    retval = String.valueOf(retval) + LDAPDecoder.decodeSearchFilter(message, filterOffset);
                    filterOffset += filterLen;
                }
                retval = String.valueOf(retval) + ")";
                break;
            }
            case 1: {
                int setLength = BerUtilities.getComponentLength(message, tagOffset);
                int setEnd = tagOffset + setLength;
                boolean firstFilterDone = false;
                retval = "(";
                int filterOffset = BerUtilities.dataOffset(message, tagOffset);
                while (filterOffset < setEnd) {
                    int filterLen = BerUtilities.getComponentLength(message, filterOffset);
                    if (firstFilterDone) {
                        retval = String.valueOf(retval) + " OR ";
                    } else {
                        firstFilterDone = true;
                    }
                    retval = String.valueOf(retval) + LDAPDecoder.decodeSearchFilter(message, filterOffset);
                    filterOffset += filterLen;
                }
                retval = String.valueOf(retval) + ")";
                break;
            }
            case 2: {
                int filterOffset = BerUtilities.dataOffset(message, tagOffset);
                retval = "(NOT " + LDAPDecoder.decodeSearchFilter(message, filterOffset) + ")";
                break;
            }
            case 3: {
                int attributeDescOffset = BerUtilities.dataOffset(message, tagOffset);
                int attributeDescLen = BerUtilities.getComponentLength(message, attributeDescOffset);
                int assertionValueOffset = attributeDescOffset + attributeDescLen;
                retval = "(" + BerUtilities.getString(message, attributeDescOffset) + "=" + BerUtilities.getString(message, assertionValueOffset) + ")";
                break;
            }
            case 4: {
                int attributeDescOffset = BerUtilities.dataOffset(message, tagOffset);
                int attributeDescLen = BerUtilities.getComponentLength(message, attributeDescOffset);
                retval = "(" + BerUtilities.getString(message, attributeDescOffset) + "=";
                int seqOffset = attributeDescOffset + attributeDescLen;
                int seqLen = BerUtilities.getComponentLength(message, seqOffset);
                int seqEnd = seqOffset + seqLen;
                int substringOffset = BerUtilities.dataOffset(message, seqOffset);
                String initialString = "*";
                String finalString = null;
                String anyString = "";
                while (substringOffset < seqEnd) {
                    int substringLen = BerUtilities.getComponentLength(message, substringOffset);
                    byte matchType = (byte)(message[substringOffset] & 0x1F);
                    switch (matchType) {
                        case 0: {
                            initialString = String.valueOf(BerUtilities.getString(message, substringOffset)) + "*";
                            break;
                        }
                        case 1: {
                            anyString = String.valueOf(anyString) + BerUtilities.getString(message, substringOffset) + "*";
                            break;
                        }
                        case 2: {
                            finalString = BerUtilities.getString(message, substringOffset);
                            break;
                        }
                        default: {
                            anyString = String.valueOf(anyString) + "illegal substring choice tag [" + matchType + "]";
                        }
                    }
                    substringOffset += substringLen;
                }
                String matchString = initialString;
                if (anyString.length() != 0) {
                    matchString = String.valueOf(matchString) + anyString;
                }
                if (finalString != null) {
                    matchString = String.valueOf(matchString) + finalString;
                }
                retval = String.valueOf(retval) + "\"" + matchString + "\")";
                break;
            }
            case 5: {
                int attributeDescOffset = BerUtilities.dataOffset(message, tagOffset);
                int attributeDescLen = BerUtilities.getComponentLength(message, attributeDescOffset);
                int assertionValueOffset = attributeDescOffset + attributeDescLen;
                retval = "(" + BerUtilities.getString(message, attributeDescOffset) + ">=" + BerUtilities.getString(message, assertionValueOffset) + ")";
                break;
            }
            case 6: {
                int attributeDescOffset = BerUtilities.dataOffset(message, tagOffset);
                int attributeDescLen = BerUtilities.getComponentLength(message, attributeDescOffset);
                int assertionValueOffset = attributeDescOffset + attributeDescLen;
                retval = "(" + BerUtilities.getString(message, attributeDescOffset) + "<=" + BerUtilities.getString(message, assertionValueOffset) + ")";
                break;
            }
            case 7: {
                retval = "(" + BerUtilities.getString(message, tagOffset) + "=*)";
                break;
            }
            case 8: {
                int attributeDescOffset = BerUtilities.dataOffset(message, tagOffset);
                int attributeDescLen = BerUtilities.getComponentLength(message, attributeDescOffset);
                int assertionValueOffset = attributeDescOffset + attributeDescLen;
                retval = "(" + BerUtilities.getString(message, attributeDescOffset) + "~=" + BerUtilities.getString(message, assertionValueOffset) + ")";
                break;
            }
            case 9: {
                int dnAttributesOffset;
                int matchValueOffset;
                int typeOffset;
                int fieldOffset = BerUtilities.dataOffset(message, tagOffset);
                String matchingRule = null;
                String type = "";
                String matchValue = "";
                boolean dnAttributes = false;
                byte tag = -127;
                int matchingRuleOffset = BerUtilities.tagOffset(message, tag, fieldOffset);
                if (matchingRuleOffset != -1) {
                    matchingRule = BerUtilities.getString(message, matchingRuleOffset);
                }
                if ((typeOffset = BerUtilities.tagOffset(message, tag = -126, fieldOffset)) != -1) {
                    type = BerUtilities.getString(message, typeOffset);
                }
                if ((matchValueOffset = BerUtilities.tagOffset(message, tag = -125, fieldOffset)) != -1) {
                    matchValue = BerUtilities.getString(message, matchValueOffset);
                }
                if ((dnAttributesOffset = BerUtilities.tagOffset(message, tag = -124, fieldOffset)) != -1) {
                    dnAttributes = BerUtilities.getInteger(message, dnAttributesOffset) != 0;
                }
                retval = "(" + type + ":" + (dnAttributes ? "dn:" : "") + (matchingRule == null ? "" : String.valueOf(matchingRule) + ":") + "=" + matchValue + ")";
                break;
            }
            default: {
                retval = "bad filter tag #" + choice;
            }
        }
        return retval;
    }

    public static String decodeSearchRequest(byte[] message, int tagOffset) {
        String retval = "Search Request {\n";
        String abbrev = "Search Request {\n  ldapsearch ";
        int baseObjectOffset = BerUtilities.dataOffset(message, tagOffset);
        int baseObjectLen = BerUtilities.getComponentLength(message, baseObjectOffset);
        int scopeOffset = baseObjectOffset + baseObjectLen;
        int scopeLen = BerUtilities.getComponentLength(message, scopeOffset);
        int derefAliasesOffset = scopeOffset + scopeLen;
        int derefAliasesLen = BerUtilities.getComponentLength(message, derefAliasesOffset);
        int sizeLimitOffset = derefAliasesOffset + derefAliasesLen;
        int sizeLimitLen = BerUtilities.getComponentLength(message, sizeLimitOffset);
        int timeLimitOffset = sizeLimitOffset + sizeLimitLen;
        int timeLimitLen = BerUtilities.getComponentLength(message, timeLimitOffset);
        int typeOnlyOffset = timeLimitOffset + timeLimitLen;
        int typeOnlyLen = BerUtilities.getComponentLength(message, typeOnlyOffset);
        int filterOffset = typeOnlyOffset + typeOnlyLen;
        int filterLen = BerUtilities.getComponentLength(message, filterOffset);
        int attributesOffset = filterOffset + filterLen;
        int attributesLen = BerUtilities.getComponentLength(message, attributesOffset);
        String baseStr = BerUtilities.getString(message, baseObjectOffset);
        retval = String.valueOf(retval) + "  baseObject   : \"" + baseStr + "\"\n";
        if (baseStr.length() != 0) {
            abbrev = String.valueOf(abbrev) + "-b \"" + baseStr + "\" ";
        }
        retval = String.valueOf(retval) + "  scope        : ";
        abbrev = String.valueOf(abbrev) + "-s ";
        int scope = BerUtilities.getInteger(message, scopeOffset);
        switch (scope) {
            case 0: {
                retval = String.valueOf(retval) + "baseObject";
                abbrev = String.valueOf(abbrev) + "base ";
                break;
            }
            case 1: {
                retval = String.valueOf(retval) + "singleLevel";
                abbrev = String.valueOf(abbrev) + "one ";
                break;
            }
            case 2: {
                retval = String.valueOf(retval) + "wholeSubtree";
                abbrev = String.valueOf(abbrev) + "sub ";
                break;
            }
            default: {
                retval = String.valueOf(retval) + "** unrecognized value **";
            }
        }
        retval = String.valueOf(retval) + " (" + scope + ")\n";
        retval = String.valueOf(retval) + "  derefAliases : ";
        abbrev = String.valueOf(abbrev) + "-a ";
        int deref = BerUtilities.getInteger(message, derefAliasesOffset);
        switch (deref) {
            case 0: {
                retval = String.valueOf(retval) + "neverDerefAliases";
                abbrev = String.valueOf(abbrev) + "never ";
                break;
            }
            case 1: {
                retval = String.valueOf(retval) + "derefInSearching";
                abbrev = String.valueOf(abbrev) + "search ";
                break;
            }
            case 2: {
                retval = String.valueOf(retval) + "derefFindingBaseObj";
                abbrev = String.valueOf(abbrev) + "find ";
                break;
            }
            case 3: {
                retval = String.valueOf(retval) + "derefAlways";
                abbrev = String.valueOf(abbrev) + "never ";
                break;
            }
            default: {
                retval = String.valueOf(retval) + "** unrecognized value **";
            }
        }
        retval = String.valueOf(retval) + " (" + deref + ")\n";
        int sizeLimit = BerUtilities.getInteger(message, sizeLimitOffset);
        int timeLimit = BerUtilities.getInteger(message, timeLimitOffset);
        retval = String.valueOf(retval) + "  sizeLimit    : " + sizeLimit + "\n";
        retval = String.valueOf(retval) + "  timeLimit    : " + timeLimit + "\n";
        if (sizeLimit != 0) {
            abbrev = String.valueOf(abbrev) + "-z " + sizeLimit + " ";
        }
        if (timeLimit != 0) {
            abbrev = String.valueOf(abbrev) + "-l " + timeLimit + " ";
        }
        int typesOnly = BerUtilities.getInteger(message, typeOnlyOffset);
        retval = String.valueOf(retval) + "  typesOnly    : " + (typesOnly == 0 ? "FALSE\n" : "TRUE\n");
        if (typesOnly != 0) {
            abbrev = String.valueOf(abbrev) + "-A ";
        }
        String filter = LDAPDecoder.decodeSearchFilter(message, filterOffset);
        retval = String.valueOf(retval) + "  filter       : " + filter + "\n";
        abbrev = String.valueOf(abbrev) + "\"" + filter + "\" ";
        retval = String.valueOf(retval) + "  attributes   : ";
        int seqEnd = attributesOffset + attributesLen;
        int fieldOffset = BerUtilities.dataOffset(message, attributesOffset);
        if (fieldOffset >= seqEnd) {
            retval = String.valueOf(retval) + "<null attribute list - all user attributes will be returned>";
        }
        while (fieldOffset < seqEnd) {
            int fieldLen = BerUtilities.getComponentLength(message, fieldOffset);
            String oneAttr = BerUtilities.getString(message, fieldOffset);
            retval = String.valueOf(retval) + "\"" + oneAttr + "\" ";
            abbrev = String.valueOf(abbrev) + "\"" + oneAttr + "\" ";
            fieldOffset += fieldLen;
        }
        retval = String.valueOf(retval) + "\n";
        retval = String.valueOf(retval) + "  }\n";
        abbrev = String.valueOf(abbrev) + "\n  }\n";
        if (optAbbreviatedSearchDecode) {
            return abbrev;
        }
        return retval;
    }

    public static String decodeSearchResultDone(byte[] message, int tagOffset) {
        String retval = "Search ResultDone {\n";
        int resultComponentsOffset = BerUtilities.dataOffset(message, tagOffset);
        retval = String.valueOf(retval) + LDAPDecoder.decodeLDAPResultComponents(message, resultComponentsOffset, 4);
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeSearchResultEntry(byte[] message, int tagOffset) {
        String retval = "Search Result Entry {\n";
        int objectNameOffset = BerUtilities.dataOffset(message, tagOffset);
        int objectNameLen = BerUtilities.getComponentLength(message, objectNameOffset);
        int partialAttributeListOffset = objectNameOffset + objectNameLen;
        retval = String.valueOf(retval) + "  objectName   : \"" + BerUtilities.getString(message, objectNameOffset) + "\"\n";
        retval = String.valueOf(retval) + "  attributes   : {\n";
        String prefix = "                   ";
        retval = optDecodeSREAttributes ? String.valueOf(retval) + LDAPDecoder.decodeAttributeList(message, partialAttributeListOffset, prefix) : String.valueOf(retval) + prefix + "<not decoding attributes for Search Result Entries>\n";
        retval = String.valueOf(retval) + "                 }\n";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public static String decodeSearchResultReference(byte[] message, int tagOffset) {
        String retval = "SearchResultReference {\n";
        int seqLen = BerUtilities.getComponentLength(message, tagOffset);
        int seqEnd = tagOffset + seqLen;
        int urlOffset = BerUtilities.dataOffset(message, tagOffset);
        retval = String.valueOf(retval) + "  URL          : {";
        String prefix = "                   ";
        while (urlOffset < seqEnd) {
            int urlLen = BerUtilities.getComponentLength(message, urlOffset);
            retval = String.valueOf(retval) + prefix + BerUtilities.getString(message, urlOffset) + "\n";
            urlOffset += urlLen;
        }
        retval = String.valueOf(retval) + "               : }";
        retval = String.valueOf(retval) + "  }\n";
        return retval;
    }

    public int getDefaultPort() {
        return 389;
    }

    public String getName() {
        return "LDAP Decoder";
    }

    public static String getOidDesc(String dottedOid) {
        if (dottedOid.equalsIgnoreCase("1.3.6.1.4.1.1466.20037")) {
            return String.valueOf(dottedOid) + " (StartTLS)";
        }
        if (dottedOid.equalsIgnoreCase("2.16.840.1.113730.3.4.2")) {
            return String.valueOf(dottedOid) + " (ManageDSAIT)";
        }
        if (dottedOid.equalsIgnoreCase("2.16.840.1.113730.3.4.3")) {
            return String.valueOf(dottedOid) + " (Persistent Search)";
        }
        if (dottedOid.equalsIgnoreCase("2.16.840.1.113730.3.4.4")) {
            return String.valueOf(dottedOid) + " (Netscape password expired)";
        }
        if (dottedOid.equalsIgnoreCase("2.16.840.1.113730.3.4.5")) {
            return String.valueOf(dottedOid) + " (Netscape password expiring)";
        }
        if (dottedOid.equalsIgnoreCase("1.2.840.113556.1.4.473")) {
            return String.valueOf(dottedOid) + " (Server Sort Result request)";
        }
        if (dottedOid.equalsIgnoreCase("1.2.840.113556.1.4.474")) {
            return String.valueOf(dottedOid) + " (Server Sort Result response)";
        }
        if (dottedOid.equalsIgnoreCase("1.2.840.113556.1.4.319")) {
            return String.valueOf(dottedOid) + " (Paged Results)";
        }
        if (dottedOid.equalsIgnoreCase("2.16.840.1.113730.3.4.9")) {
            return String.valueOf(dottedOid) + " (Virtual list view request)";
        }
        if (dottedOid.equalsIgnoreCase("2.16.840.1.113730.3.4.10")) {
            return String.valueOf(dottedOid) + " (Virtual list view response)";
        }
        return dottedOid;
    }

    public synchronized JPanel getOptionsPanel() {
        if (this.optionsPanel != null) {
            return this.optionsPanel;
        }
        final JCheckBox cb1 = new JCheckBox(" Decode attributes inside search results");
        cb1.setSelected(optDecodeSREAttributes);
        cb1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                optDecodeSREAttributes = cb1.isSelected();
            }
        });
        final JCheckBox cb2 = new JCheckBox(" Show SearchRequests in \"ldapsearch\" format");
        cb2.setSelected(optAbbreviatedSearchDecode);
        cb2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                optAbbreviatedSearchDecode = cb2.isSelected();
            }
        });
        this.optionsPanel = new JPanel(new GridLayout(2, 2));
        this.optionsPanel.add(cb1);
        this.optionsPanel.add(cb2);
        return this.optionsPanel;
    }

    public String getVersion() {
        return moduleVersion;
    }

    private void switchToSSL() {
        this.sslDecoder = new SSLDecoder();
        this.sslDecoder.setSink(this.sink);
        this.sslDecoder.setName(String.valueOf(this.decoderName) + " ** SSL ** ");
        this.sslDecoder.decodeData(this.cache.toByteArray());
        this.cache.reset();
    }
}

