/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.util.NickohLogHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Logger;

public class OnewaySnooper
implements Runnable {
    private static final String moduleVersion = "1.0";
    private static Logger logger = NickohLogHandler.getLogger();
    protected Thread parentThread = null;
    protected InputStream iStream = null;
    protected OutputStream oStream = null;
    public static final int bufferSize = 8192;
    protected ByteArrayOutputStream cacheBuffer = null;
    protected boolean cacheEmpty = true;
    protected boolean snoopFinished = false;
    protected Socket toSocket = null;
    protected Socket fromSocket = null;
    protected boolean socketsOpen = false;

    public OnewaySnooper(Socket fromSocket, Socket toSocket, Thread parentThread) throws IOException {
        this.iStream = fromSocket.getInputStream();
        this.oStream = toSocket.getOutputStream();
        this.parentThread = parentThread;
        this.fromSocket = fromSocket;
        this.toSocket = toSocket;
        this.cacheBuffer = new ByteArrayOutputStream(8192);
        this.socketsOpen = true;
    }

    protected synchronized void addToCache(byte[] buffer, int count) {
        this.cacheBuffer.write(buffer, 0, count);
        boolean bl = this.cacheEmpty = this.cacheBuffer.size() == 0;
        if (!this.cacheEmpty) {
            this.wakeParent();
        }
    }

    public synchronized byte[] getPendingData() {
        byte[] retval = this.cacheBuffer.toByteArray();
        this.cacheBuffer.reset();
        this.cacheEmpty = true;
        if (retval.length == 0) {
            this.snoopFinished = !this.socketsOpen;
            return null;
        }
        return retval;
    }

    public boolean isSnoopFinished() {
        return this.snoopFinished;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            logger.info("OneWaySnooper thread " + Thread.currentThread() + " starting");
            this.snoop();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            logger.info("thread " + Thread.currentThread() + " terminating");
            this.wakeParent();
            throw throwable;
        }
        {
            Object var1_3 = null;
            logger.info("thread " + Thread.currentThread() + " terminating");
            this.wakeParent();
            return;
        }
    }

    public void setParentThread(Thread thread) {
        this.parentThread = thread;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void snoop() {
        int bytesRead = 0;
        try {
            try {
                do {
                    byte[] buffer = new byte[8192];
                    logger.info("thread " + Thread.currentThread() + " about to issue read");
                    bytesRead = this.iStream.read(buffer, 0, 8192);
                    logger.info("thread " + Thread.currentThread() + " read " + bytesRead + " bytes");
                    if (bytesRead <= 0) continue;
                    this.addToCache(buffer, bytesRead);
                    this.oStream.write(buffer, 0, bytesRead);
                } while (bytesRead >= 0);
            }
            catch (IOException e) {
                logger.info("thread " + Thread.currentThread() + " caught " + e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.socketsOpen = false;
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.socketsOpen = false;
            return;
        }
    }

    protected void wakeParent() {
        if (this.parentThread != null && this.parentThread.isAlive()) {
            this.parentThread.interrupt();
        }
    }
}

