/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.Decoder;
import com.nickoh.snooper.TwowaySnooper;
import com.nickoh.util.NickohLogHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Stack;
import java.util.logging.Logger;

public abstract class ProxyServer
implements Runnable {
    private static final String moduleVersion = "1.0";
    private static Logger logger = NickohLogHandler.getLogger();
    protected Class decoderClass;
    protected Class sinkClass;
    protected ServerSocket listeningSocket;
    protected InetAddress server;
    protected int serverPort;
    protected Stack twsStack;
    protected int connectionCount;
    protected int listenPort;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ProxyServer(InetAddress server, int serverPort, int listenPort, Class decoderClass, Class sinkClass) throws IOException {
        block13: {
            block12: {
                this.decoderClass = null;
                this.sinkClass = null;
                this.listeningSocket = null;
                this.server = null;
                this.twsStack = new Stack();
                this.connectionCount = 0;
                if (server == null || decoderClass == null || sinkClass == null) {
                    throw new NullPointerException();
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.nickoh.snooper.Decoder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(decoderClass)) break block12;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("com.nickoh.snooper.DecoderSink");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.isAssignableFrom(sinkClass)) break block13;
            }
            throw new ClassCastException();
        }
        this.listeningSocket = new ServerSocket(listenPort);
        this.server = server;
        this.serverPort = serverPort;
        this.decoderClass = decoderClass;
        this.sinkClass = sinkClass;
        this.listenPort = listenPort;
    }

    protected void cleanup() {
    }

    protected TwowaySnooper createTwowaySnooper(Socket clientSocket, Decoder clientDecoder, Decoder serverDecoder) {
        TwowaySnooper tws = null;
        try {
            tws = new TwowaySnooper(this.server, this.serverPort, clientSocket, clientDecoder, serverDecoder);
        }
        catch (Exception e) {
            clientDecoder.displayMessage("\n" + Decoder.getTimeNow() + " : " + "Couldn't establish connection : " + e + "\n");
            logger.info("Couldn't create TwowaySnooper : " + e);
        }
        return tws;
    }

    public void run() {
        logger.info("ProxyServer for " + this.server.getHostName() + ":" + this.serverPort + " started listening on port " + this.listenPort);
        Socket clientSocket = null;
        String serverName = this.server.getHostName();
        block9: while (true) {
            try {
                while (true) {
                    try {
                        clientSocket = this.listeningSocket.accept();
                        logger.info("connection received from " + clientSocket.getInetAddress().getHostName());
                    }
                    catch (IOException e) {
                        logger.info("Error on accept() for Connection #" + (this.connectionCount + 1) + " for server " + serverName + " : " + e);
                        Object var8_10 = null;
                        logger.info("ProxyServer for " + this.server.getHostName() + ":" + this.serverPort + " finished");
                        try {
                            this.listeningSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.cleanup();
                        return;
                    }
                    String clientName = clientSocket.getInetAddress().getHostName();
                    ++this.connectionCount;
                    Decoder clientDecoder = this.setupClientDecoder(clientSocket.getInetAddress());
                    clientDecoder.displayMessage("\n" + Decoder.getTimeNow() + " : " + clientName + " has requested a connection\n");
                    Decoder serverDecoder = this.setupServerDecoder();
                    TwowaySnooper tws = this.createTwowaySnooper(clientSocket, clientDecoder, serverDecoder);
                    if (tws != null) {
                        this.twsStack.push(tws);
                        Thread t = new Thread(tws);
                        logger.info("Starting TwowaySnooper thread");
                        t.start();
                        continue;
                    }
                    clientDecoder.displayMessage("\n" + Decoder.getTimeNow() + " : dropping connection to " + clientName + "\n");
                    try {
                        clientSocket.close();
                        continue block9;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                logger.info("ProxyServer for " + this.server.getHostName() + ":" + this.serverPort + " finished");
                try {
                    this.listeningSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.cleanup();
                throw throwable;
            }
        }
    }

    protected abstract Decoder setupClientDecoder(InetAddress var1);

    protected abstract Decoder setupServerDecoder();

    public void shutdown() {
        logger.info("shutdown called on : " + this);
        while (!this.twsStack.isEmpty()) {
            TwowaySnooper tws = (TwowaySnooper)this.twsStack.pop();
            tws.shutdown();
        }
        try {
            this.listeningSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

