/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.ASN1Decoder;
import com.nickoh.snooper.ConformanceException;
import com.nickoh.snooper.HexDecoder;
import com.nickoh.snooper.TPDU;
import com.nickoh.snooper.TSDU;
import com.nickoh.util.NickohLogHandler;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class RFC1006Decoder
extends ASN1Decoder {
    private static String moduleVersion = "1.0";
    private static Logger logger = NickohLogHandler.getLogger();
    private boolean splitUserData = false;
    private ByteArrayOutputStream asn1Stream = new ByteArrayOutputStream();
    protected static boolean optDecodeMessageAsAsn1 = true;
    private static JPanel optionsPanel;
    protected static boolean optShowTpktHeaders;
    protected static boolean optDecodeMessageAsHex;
    protected static boolean optShowTPDUHeaders;

    static {
        optShowTpktHeaders = false;
        optDecodeMessageAsHex = false;
        optShowTPDUHeaders = true;
    }

    protected void checkForCompleteMessage() {
        boolean doneHeader = false;
        while (this.cache.size() >= 4) {
            byte[] message = this.cache.toByteArray();
            int packetLength = (message[2] & 0xFF) * 256;
            if (message.length < (packetLength += message[3] & 0xFF)) {
                return;
            }
            if (!doneHeader) {
                this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n");
                doneHeader = true;
            }
            if (optShowTpktHeaders) {
                this.displayMessage("TPKT version  = " + (message[0] & 0xFF));
                this.displayMessage("; packet length = " + packetLength + " (0x" + Integer.toHexString(packetLength) + ")\n");
            }
            try {
                TPDU tpdu = new TPDU(message, 4, packetLength - 4);
                if (optShowTPDUHeaders) {
                    this.displayMessage(tpdu.formatHeader("  "));
                } else {
                    this.displayMessage("  TPDU type : " + tpdu.getTpduName() + "\n");
                }
                switch (tpdu.getTpduCode()) {
                    case 240: {
                        try {
                            byte[] userData;
                            if (!this.splitUserData) {
                                this.displayMessage("\n  The TPDU's TSDU contains the following SPDUs..\n");
                                userData = tpdu.getUserData();
                                if (userData != null) {
                                    TSDU tsdu = new TSDU(userData);
                                    this.displayMessage(tsdu.formatContents("    "));
                                    byte[] userInfo = tsdu.getUserInfo();
                                    if (userInfo != null) {
                                        this.asn1Stream.reset();
                                        this.asn1Stream.write(userInfo);
                                    }
                                }
                            } else {
                                userData = tpdu.getUserData();
                                this.displayMessage("      -- continuation TPDU with " + userData.length + " (0x" + Integer.toHexString(userData.length) + ") bytes\n");
                                this.asn1Stream.write(userData);
                            }
                            if (!tpdu.isEOT()) {
                                this.splitUserData = true;
                                break;
                            }
                            this.splitUserData = false;
                            byte[] fullMessage = this.asn1Stream.toByteArray();
                            if (fullMessage.length <= 1) break;
                            if (optDecodeMessageAsAsn1) {
                                this.displayMessage("      Decoding user info as ASN.1 :\n");
                                this.displayMessage(ASN1Decoder.decodeTLV(fullMessage, 0, fullMessage.length - 1, 8));
                            }
                            if (!optDecodeMessageAsHex) break;
                            this.displayMessage("      Dumping user info in Hex :\n");
                            this.displayMessage(HexDecoder.hexify(fullMessage, "        "));
                        }
                        catch (Exception e) {
                            this.displayMessage("\n  Unable to decode user data for TSDU : " + e + "\n");
                        }
                        break;
                    }
                    case 112: 
                    case 128: 
                    case 208: 
                    case 224: {
                        this.displayMessage("\n  This type of TPDU contains no SPDUs in class 0\n");
                    }
                }
            }
            catch (ConformanceException e) {
                this.displayMessage("  " + e + "\n");
                logger.info("RFC1006 decoder got : " + e);
            }
            this.displayMessage("\n");
            this.cache.reset();
            if (packetLength >= message.length) continue;
            this.cache.write(message, packetLength, message.length - packetLength);
        }
        return;
    }

    public int getDefaultPort() {
        return 102;
    }

    public String getName() {
        return "RFC1006 Decoder";
    }

    public synchronized JPanel getOptionsPanel() {
        if (optionsPanel != null) {
            return optionsPanel;
        }
        final JCheckBox cb1 = new JCheckBox(" Show TPKT headers");
        cb1.setSelected(optShowTpktHeaders);
        cb1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                optShowTpktHeaders = cb1.isSelected();
            }
        });
        final JCheckBox cb4 = new JCheckBox(" Show TPDU headers");
        cb4.setSelected(optShowTPDUHeaders);
        cb4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                optShowTPDUHeaders = cb4.isSelected();
            }
        });
        final JCheckBox cb2 = new JCheckBox(" Show User Data as ASN.1");
        cb2.setSelected(optDecodeMessageAsAsn1);
        cb2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                optDecodeMessageAsAsn1 = cb2.isSelected();
            }
        });
        final JCheckBox cb3 = new JCheckBox(" Dump User Data in Hex");
        cb3.setSelected(optDecodeMessageAsHex);
        cb3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                optDecodeMessageAsHex = cb3.isSelected();
                if (optDecodeMessageAsHex) {
                    HexDecoder.setDumpStyle(1);
                }
            }
        });
        optionsPanel = new JPanel(new GridLayout(2, 2));
        optionsPanel.add(cb1);
        optionsPanel.add(cb4);
        optionsPanel.add(cb2);
        optionsPanel.add(cb3);
        return optionsPanel;
    }

    public String getVersion() {
        return moduleVersion;
    }
}

