/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.ASN1Decoder;
import com.nickoh.snooper.HexDecoder;
import com.nickoh.snooper.RFC1006Decoder;

public class SPDU {
    private static final String moduleVersion = "1.0";
    protected byte[] data = null;
    protected int spduType = -1;
    protected int lengthIndicator = -1;
    protected int liLength = -1;
    protected int userInfoOffset = -1;
    protected int paramOffset = -1;
    protected int userInfoLen = -1;
    protected String siName = null;

    public SPDU(byte[] byteArray) {
        this(byteArray, null);
    }

    private SPDU(byte[] byteArray, int startPos) {
        if (byteArray == null) {
            throw new ArrayIndexOutOfBoundsException("empty array");
        }
        if (startPos > byteArray.length) {
            throw new ArrayIndexOutOfBoundsException("length too big");
        }
        this.spduType = byteArray[startPos] & 0xFF;
        this.liLength = (byteArray[startPos + 1] & 0xFF) == 255 ? 3 : 1;
        this.lengthIndicator = this.liLength == 1 ? byteArray[startPos + 1] & 0xFF : (byteArray[startPos + 2] & 0xFF) * 256 + (byteArray[startPos + 3] & 0xFF);
        this.paramOffset = startPos + 1 + this.liLength;
        this.userInfoOffset = this.paramOffset + this.lengthIndicator;
        switch (this.spduType) {
            case 13: {
                this.userInfoLen = 0;
                break;
            }
            case 16: {
                this.userInfoLen = 0;
                break;
            }
            case 15: {
                this.userInfoLen = 0;
                break;
            }
            case 14: {
                this.userInfoLen = 0;
                break;
            }
            case 12: {
                this.userInfoLen = 0;
                break;
            }
            case 9: {
                this.userInfoLen = 0;
                break;
            }
            case 10: {
                this.userInfoLen = 0;
                break;
            }
            case 8: {
                this.userInfoLen = 0;
                break;
            }
            case 25: {
                this.userInfoLen = 0;
                break;
            }
            case 26: {
                this.userInfoLen = 0;
                break;
            }
            case 1: 
            case 5: 
            case 33: 
            case 61: {
                this.userInfoLen = 0;
                break;
            }
            case 62: {
                this.userInfoLen = 0;
                break;
            }
            case 2: {
                this.userInfoLen = 0;
                break;
            }
            case 21: {
                this.userInfoLen = 0;
                break;
            }
            case 22: {
                this.userInfoLen = 0;
                break;
            }
            case 49: {
                this.userInfoLen = 0;
                break;
            }
            case 50: {
                this.userInfoLen = 0;
                break;
            }
            case 41: {
                this.userInfoLen = 0;
                break;
            }
            case 42: {
                this.userInfoLen = 0;
                break;
            }
            case 53: {
                this.userInfoLen = 0;
                break;
            }
            case 34: {
                this.userInfoLen = 0;
                break;
            }
            case 7: {
                this.userInfoLen = 0;
                break;
            }
            case 0: {
                this.userInfoLen = 0;
                break;
            }
            case 48: {
                this.userInfoLen = 0;
                break;
            }
            case 45: {
                this.userInfoLen = 0;
                break;
            }
            case 29: {
                this.userInfoLen = 0;
                break;
            }
            case 57: {
                this.userInfoLen = 0;
                break;
            }
            case 58: {
                this.userInfoLen = 0;
            }
        }
    }

    public SPDU(byte[] byteArray, String name) {
        if (byteArray == null) {
            throw new ArrayIndexOutOfBoundsException("empty array");
        }
        if (byteArray.length < 2) {
            throw new ArrayIndexOutOfBoundsException("too small for an SPDU");
        }
        this.data = new byte[byteArray.length];
        System.arraycopy(byteArray, 0, this.data, 0, this.data.length);
        this.spduType = this.data[0] & 0xFF;
        this.siName = name != null ? name : "Code #" + this.spduType;
        this.liLength = 1;
        this.lengthIndicator = this.data[1] & 0xFF;
        if (this.lengthIndicator == 255) {
            this.liLength = 3;
            this.lengthIndicator = (this.data[2] & 0xFF) * 256 + (this.data[3] & 0xFF);
        }
        this.paramOffset = 1 + this.liLength;
        if (this.paramOffset >= this.data.length) {
            this.paramOffset = -1;
            return;
        }
        this.userInfoOffset = this.paramOffset + this.lengthIndicator;
        if (this.userInfoOffset >= byteArray.length) {
            this.userInfoOffset = -1;
        }
        this.userInfoLen = this.data.length - this.userInfoOffset;
    }

    private String formatParameter(int offset, String prefix) {
        String retval = "";
        int paramCode = this.data[offset] & 0xFF;
        int li = this.data[offset + 1] & 0xFF;
        String pgiName = null;
        block0 : switch (paramCode) {
            case 19: {
                retval = String.valueOf(retval) + prefix + "Protocol options : ";
                retval = String.valueOf(retval) + "Initiator can";
                if ((this.data[offset + 2] & 1) == 0) {
                    retval = String.valueOf(retval) + "not";
                }
                retval = String.valueOf(retval) + " receive extended SPDUs\n";
                break;
            }
            case 22: {
                retval = String.valueOf(retval) + prefix + "Version proposed : 0x" + Integer.toHexString(this.data[offset + 2]) + "\n";
                break;
            }
            case 51: {
                retval = String.valueOf(retval) + prefix + "Calling SSEL     : \"";
                retval = String.valueOf(retval) + new String(this.data, offset + 2, li) + "\"\n";
                break;
            }
            case 52: {
                retval = String.valueOf(retval) + prefix + "Called SSEL      : \"";
                retval = String.valueOf(retval) + new String(this.data, offset + 2, li) + "\"\n";
                break;
            }
            case 20: {
                retval = String.valueOf(retval) + prefix + "Sess. user reqs  : 0x" + Integer.toHexString(this.data[offset + 2] & 0xFF) + Integer.toHexString(this.data[offset + 3] & 0xFF) + "\n";
                retval = String.valueOf(retval) + prefix + "    --decodes to : ";
                if ((this.data[offset + 2] & 1) != 0) {
                    retval = String.valueOf(retval) + "half-duplex; ";
                }
                if ((this.data[offset + 2] & 2) != 0) {
                    retval = String.valueOf(retval) + "duplex; ";
                }
                if ((this.data[offset + 2] & 4) != 0) {
                    retval = String.valueOf(retval) + "expedited data; ";
                }
                if ((this.data[offset + 2] & 8) != 0) {
                    retval = String.valueOf(retval) + "minor sync; ";
                }
                if ((this.data[offset + 2] & 0x10) != 0) {
                    retval = String.valueOf(retval) + "major sync; ";
                }
                if ((this.data[offset + 2] & 0x20) != 0) {
                    retval = String.valueOf(retval) + " resynch; ";
                }
                if ((this.data[offset + 2] & 0x40) != 0) {
                    retval = String.valueOf(retval) + "activity mgt; ";
                }
                if ((this.data[offset + 2] & 0x80) != 0) {
                    retval = String.valueOf(retval) + "negotiated release; ";
                }
                if ((this.data[offset + 3] & 1) != 0) {
                    retval = String.valueOf(retval) + "capability data; ";
                }
                if ((this.data[offset + 3] & 2) != 0) {
                    retval = String.valueOf(retval) + "exceptions; ";
                }
                if ((this.data[offset + 3] & 4) != 0) {
                    retval = String.valueOf(retval) + "typed data ";
                }
                retval = String.valueOf(retval) + "\n";
                break;
            }
            case 17: {
                retval = String.valueOf(retval) + prefix + "Transport disc.  : ";
                int param = this.data[offset + 2] & 0xFF;
                retval = String.valueOf(retval) + ((param & 1) == 1 ? "release transport connection" : "keep transport connection") + " (paramValue = 0x" + Integer.toHexString(param) + ")\n";
                break;
            }
            case 50: {
                retval = String.valueOf(retval) + prefix + "Reason code      : 0x";
                int param = this.data[offset + 2] & 0xFF;
                retval = String.valueOf(retval) + Integer.toHexString(param);
                switch (param) {
                    case 0: {
                        retval = String.valueOf(retval) + " (rejection by called SS-user; reason not specified)\n";
                        break block0;
                    }
                    case 1: {
                        retval = String.valueOf(retval) + " (rejection by called SS-user due to temporary congestion)\n";
                        break block0;
                    }
                    case 2: {
                        retval = String.valueOf(retval) + " (rejection by called SS-user)  Supplementary info follows:\n";
                        retval = String.valueOf(retval) + HexDecoder.hexify(this.data, offset + 3, li - 2, String.valueOf(prefix) + "                    ") + "\n";
                        break block0;
                    }
                    case 129: {
                        retval = String.valueOf(retval) + " (session selector unknown)\n";
                        break block0;
                    }
                    case 130: {
                        retval = String.valueOf(retval) + " (SS-user not attached to SSAP)\n";
                        break block0;
                    }
                    case 131: {
                        retval = String.valueOf(retval) + " (SPM congestion at connect time)\n";
                        break block0;
                    }
                    case 132: {
                        retval = String.valueOf(retval) + " (proposed protocol versions not supported)\n";
                        break block0;
                    }
                    case 133: {
                        retval = String.valueOf(retval) + " (rejection by the SPM; reason not specified)\n";
                        break block0;
                    }
                    case 134: {
                        retval = String.valueOf(retval) + " (rejection by the SPM; implementation restriction)\n";
                        break block0;
                    }
                }
                retval = String.valueOf(retval) + " (unrecognized reason code)\n";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 41: 
            case 42: 
            case 46: 
            case 49: 
            case 60: {
                retval = String.valueOf(retval) + prefix + "PI param code #" + paramCode + " decode NYI\n";
                break;
            }
            case 5: {
                pgiName = String.valueOf(prefix) + "Connect/Accept item  ";
                break;
            }
            case 1: {
                pgiName = String.valueOf(prefix) + "Connection identifier";
                break;
            }
            case 33: {
                pgiName = String.valueOf(prefix) + "Linking Information  ";
                break;
            }
            case 193: {
                retval = String.valueOf(retval) + prefix + li + " (0x" + Integer.toHexString(li) + ") bytes of user data\n";
                if (RFC1006Decoder.optDecodeMessageAsAsn1) {
                    retval = String.valueOf(retval) + prefix + "ASN.1 dump of user data follows :\n";
                    retval = String.valueOf(retval) + ASN1Decoder.decodeTLV(this.data, offset + 2, offset + 2 + li, prefix.length() + 2);
                }
                if (!RFC1006Decoder.optDecodeMessageAsHex) break;
                retval = String.valueOf(retval) + prefix + "Hex dump of user data follows :\n";
                retval = String.valueOf(retval) + HexDecoder.hexify(this.data, offset + 2, li, String.valueOf(prefix) + "  ");
                break;
            }
            case 194: {
                retval = String.valueOf(retval) + prefix + li + " (0x" + Integer.toHexString(li) + " bytes) of Extended user data\n";
                if (RFC1006Decoder.optDecodeMessageAsAsn1) {
                    retval = String.valueOf(retval) + prefix + "ASN.1 dump of extended user data follows :\n";
                    retval = String.valueOf(retval) + ASN1Decoder.decodeTLV(this.data, offset + 2, offset + 2 + li, prefix.length() + 2);
                }
                if (!RFC1006Decoder.optDecodeMessageAsHex) break;
                retval = String.valueOf(retval) + prefix + "Hex dump of extended user data follows :\n";
                retval = String.valueOf(retval) + HexDecoder.hexify(this.data, offset + 2, li, String.valueOf(prefix) + "  ");
                break;
            }
            default: {
                retval = String.valueOf(retval) + prefix + "param code #" + paramCode + " not recognized\n";
            }
        }
        if (pgiName != null) {
            int piOffset = offset + 2;
            int piCount = 0;
            int endOfPgi = offset + 2 + li;
            while (piOffset < endOfPgi) {
                retval = String.valueOf(retval) + this.formatParameter(piOffset, String.valueOf(pgiName) + " PI #" + piCount + " : ");
                piOffset += (this.data[piOffset + 1] & 0xFF) + 2;
                ++piCount;
            }
        }
        return retval;
    }

    public String formatParameters(String prefix) {
        String retval = "";
        if (this.lengthIndicator == 0) {
            retval = String.valueOf(retval) + prefix + "No SPDU parameters present\n";
            return retval;
        }
        retval = String.valueOf(retval) + prefix + "SPDU parameters :\n";
        int count = 0;
        int offset = this.getParamOffset(count);
        while (offset != -1) {
            int paramCode = this.data[offset] & 0xFF;
            int li = this.data[offset + 1] & 0xFF;
            retval = String.valueOf(retval) + this.formatParameter(offset, String.valueOf(prefix) + "  ");
            offset = this.getParamOffset(++count);
        }
        return retval;
    }

    public int getLengthIndicator() {
        return this.lengthIndicator;
    }

    private int getParamOffset(int index) {
        if (this.lengthIndicator == 0) {
            return -1;
        }
        if (index == 0) {
            return this.paramOffset;
        }
        int endOfParams = this.paramOffset + this.lengthIndicator;
        int offset = this.paramOffset;
        int count = 0;
        try {
            do {
                int li;
                if ((offset += (li = this.data[offset + 1] & 0xFF) + 2) < endOfParams) continue;
                return -1;
            } while (++count < index);
            return offset;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public String getSiName() {
        return this.siName;
    }

    public int getSpduType() {
        return this.spduType;
    }

    public byte[] getUserInfo() {
        if (this.userInfoOffset == -1) {
            return null;
        }
        byte[] retval = new byte[this.userInfoLen];
        System.arraycopy(this.data, this.userInfoOffset, retval, 0, this.userInfoLen);
        return retval;
    }
}

