/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.asn.BerUtilities;
import com.nickoh.asn.Oid;
import com.nickoh.asn.X509Certificate;
import com.nickoh.snooper.ASN1Decoder;
import com.nickoh.snooper.Decoder;
import com.nickoh.snooper.HexDecoder;
import com.nickoh.snooper.LDAPDecoder;
import com.nickoh.util.NickohLogHandler;
import java.io.ByteArrayOutputStream;
import java.util.logging.Logger;
import sun.security.x509.X509CertImpl;

public class SSLDecoder
extends Decoder {
    private static final String moduleVersion = "1.0";
    private static Logger logger = NickohLogHandler.getLogger();
    public static final int initialCacheSize = 8192;
    protected ByteArrayOutputStream cache = new ByteArrayOutputStream(8192);
    public static final byte SSLV2_HANDSHAKE_PROTOCOL = -128;
    public static final byte SSL3_RT_CHANGE_CIPHER_SPEC = 20;
    public static final byte SSL3_RT_ALERT = 21;
    public static final byte SSL3_RT_HANDSHAKE = 22;
    public static final byte SSL3_RT_APPLICATION_DATA = 23;
    public static final byte SSL3_AL_WARNING = 1;
    public static final byte SSL3_AL_FATAL = 2;
    public static final byte SSL3_AD_CLOSE_NOTIFY = 0;
    public static final byte SSL3_AD_UNEXPECTED_MESSAGE = 10;
    public static final byte SSL3_AD_BAD_RECORD_MAC = 20;
    public static final byte SSL3_AD_DECOMPRESSION_FAILURE = 30;
    public static final byte SSL3_AD_HANDSHAKE_FAILURE = 40;
    public static final byte SSL3_AD_NO_CERTIFICATE = 41;
    public static final byte SSL3_AD_BAD_CERTIFICATE = 42;
    public static final byte SSL3_AD_UNSUPPORTED_CERTIFICATE = 43;
    public static final byte SSL3_AD_CERTIFICATE_REVOKED = 44;
    public static final byte SSL3_AD_CERTIFICATE_EXPIRED = 45;
    public static final byte SSL3_AD_CERTIFICATE_UNKNOWN = 46;
    public static final byte SSL3_AD_ILLEGAL_PARAMETER = 47;
    public static final byte SSL3_MT_HELLO_REQUEST = 0;
    public static final byte SSL3_MT_CLIENT_HELLO = 1;
    public static final byte SSL3_MT_SERVER_HELLO = 2;
    public static final byte SSL3_MT_CERTIFICATE = 11;
    public static final byte SSL3_MT_SERVER_KEY_EXCHANGE = 12;
    public static final byte SSL3_MT_CERTIFICATE_REQUEST = 13;
    public static final byte SSL3_MT_SERVER_DONE = 14;
    public static final byte SSL3_MT_CERTIFICATE_VERIFY = 15;
    public static final byte SSL3_MT_CLIENT_KEY_EXCHANGE = 16;
    public static final byte SSL3_MT_FINISHED = 20;
    public static final byte SSL3_CT_RSA_SIGN = 1;
    public static final byte SSL3_CT_DSS_SIGN = 2;
    public static final byte SSL3_CT_RSA_FIXED_DH = 3;
    public static final byte SSL3_CT_DSS_FIXED_DH = 4;
    public static final byte SSL3_CT_RSA_EPHEMERAL_DH = 5;
    public static final byte SSL3_CT_DSS_EPHEMERAL_DH = 6;
    public static final byte SSL3_CT_FORTEZZA_DMS = 20;
    public static final byte SSL3_CT_NUMBER = 7;
    public static final byte TLS1_AD_DECRYPTION_FAILED = 21;
    public static final byte TLS1_AD_RECORD_OVERFLOW = 22;
    public static final byte TLS1_AD_UNKNOWN_CA = 48;
    public static final byte TLS1_AD_ACCESS_DENIED = 49;
    public static final byte TLS1_AD_DECODE_ERROR = 50;
    public static final byte TLS1_AD_DECRYPT_ERROR = 51;
    public static final byte TLS1_AD_EXPORT_RESTRICTION = 60;
    public static final byte TLS1_AD_PROTOCOL_VERSION = 70;
    public static final byte TLS1_AD_INSUFFICIENT_SECURITY = 71;
    public static final byte TLS1_AD_INTERNAL_ERROR = 80;
    public static final byte TLS1_AD_USER_CANCELLED = 90;
    public static final byte TLS1_AD_NO_RENEGOTIATION = 100;
    public static final String[][] cipherSuites = new String[][]{{"000000", "SSL2 NULL-MD5"}, {"010080", "SSL2 RC4-MD5"}, {"020080", "SSL2 EXP-RC4-MD5"}, {"030080", "SSL2 RC2-CBC-MD5"}, {"040080", "SSL2 EXP-RC2-CBC-MD5"}, {"050080", "SSL2 IDEA-CBC-MD5"}, {"060040", "SSL2 DES-CBC-MD5"}, {"060140", "SSL2 DES-CBC-SHA"}, {"0700c0", "SSL2 DES-CBC3-MD5"}, {"0701c0", "SSL2 DES-CBC3-SHA"}, {"080080", "SSL2 RC4-64-MD5"}, {"ff0800", "SSL2 DES-CFB-M1"}, {"ff0810", "SSL2 NULL-MD5"}, {"000001", "SSL3 NULL-MD5"}, {"000002", "SSL3 NULL-SHA"}, {"000003", "SSL3 EXP-RC4-MD5"}, {"000004", "SSL3 RC4-MD5"}, {"000005", "SSL3 RC4-SHA"}, {"000006", "SSL3 EXP-RC2-CBC-MD5"}, {"000007", "SSL3 IDEA-CBC-SHA"}, {"000008", "SSL3 EXP-DES-CBC-SHA"}, {"000009", "SSL3 DES-CBC-SHA"}, {"00000A", "SSL3 DES-CBC3-SHA"}, {"00000B", "SSL3 EXP-DH-DSS-DES-CBC-SHA"}, {"00000C", "SSL3 DH-DSS-DES-CBC-SHA"}, {"00000D", "SSL3 DH-DSS-DES-CBC3-SHA"}, {"00000E", "SSL3 EXP-DH-RSA-DES-CBC-SHA"}, {"00000F", "SSL3 DH-RSA-DES-CBC-SHA"}, {"000010", "SSL3 DH-RSA-DES-CBC3-SHA"}, {"000011", "SSL3 EXP-EDH-DSS-DES-CBC-SHA"}, {"000012", "SSL3 EDH-DSS-DES-CBC-SHA"}, {"000013", "SSL3 EDH-DSS-DES-CBC3-SHA"}, {"000014", "SSL3 EXP-EDH-RSA-DES-CBC-SHA"}, {"000015", "SSL3 EDH-RSA-DES-CBC-SHA"}, {"000016", "SSL3 EDH-RSA-DES-CBC3-SHA"}, {"000017", "SSL3 EXP-ADH-RC4-MD5"}, {"000018", "SSL3 ADH-RC4-MD5"}, {"000019", "SSL3 EXP-ADH-DES-CBC-SHA"}, {"00001A", "SSL3 ADH-DES-CBC-SHA"}, {"00001B", "SSL3 ADH-DES-CBC3-SHA"}, {"00001C", "SSL3 FZA-NULL-SHA"}, {"00001D", "SSL3 FZA-FZA-CBC-SHA"}, {"00001E", "SSL3 FZA-RC4-SHA"}, {"000060", "TLS EXP1024-RC4-MD5"}, {"000061", "TLS EXP1024-RC2-CBC-MD5"}, {"000062", "TLS EXP1024-DES-CBC-SHA"}, {"000063", "TLS EXP1024-DHE-DSS-DES-CBC-SHA"}, {"000064", "TLS EXP1024-RC4-SHA"}, {"000065", "TLS EXP1024-DHE-DSS-RC4-SHA"}, {"000066", "TLS DHE-DSS-RC4-SHA"}};
    private X509Certificate x509 = null;

    public static int byteToInt(byte byteVal) {
        return byteVal & 0xFF;
    }

    protected void checkForCompleteMessage() {
        boolean processedSomething = true;
        do {
            if (this.cache.size() < 2) {
                return;
            }
            byte[] message = this.cache.toByteArray();
            switch (message[0]) {
                case -128: {
                    processedSomething = this.parseSSLV2Handshake(message);
                    break;
                }
                case 21: {
                    processedSomething = this.parseSSL3Alert(message);
                    break;
                }
                case 22: {
                    processedSomething = this.parseSSL3Handshake(message);
                    break;
                }
                case 23: {
                    processedSomething = this.parseSSL3ApplicationData(message);
                    break;
                }
                case 20: {
                    processedSomething = this.parseSSL3ChangeCipherSpec(message);
                    break;
                }
                default: {
                    this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n");
                    this.displayMessage("Unrecognized SSL message ( code#" + message[0] + ")\n");
                    String result = LDAPDecoder.decodeLDAPMessage(message);
                    if (!result.startsWith("Error : ")) {
                        this.displayMessage("Decoding message as LDAP gives: \n" + result);
                    } else {
                        result = ASN1Decoder.decodeTLV(message, 0, message.length, 4);
                        if (!result.startsWith("Error : ")) {
                            this.displayMessage("Decoding message as ASN.1 gives : \n" + result);
                        } else {
                            this.displayMessage("Message contents : \n" + HexDecoder.hexify(message, message.length, "    "));
                        }
                    }
                    processedSomething = false;
                }
            }
        } while (processedSomething);
    }

    public static String decodeCipherName(byte[] byteArray, int startOffset, boolean isv2) {
        int cipherValue = SSLDecoder.byteToInt(byteArray[startOffset]);
        cipherValue = cipherValue * 256 + SSLDecoder.byteToInt(byteArray[startOffset + 1]);
        if (isv2) {
            cipherValue = cipherValue * 256 + SSLDecoder.byteToInt(byteArray[startOffset + 2]);
        }
        String cipherName = "Unknown cipher : 0x" + Integer.toHexString(cipherValue);
        int i = 0;
        while (i < cipherSuites.length) {
            if (cipherValue == Integer.parseInt(cipherSuites[i][0], 16)) {
                cipherName = cipherSuites[i][1];
                break;
            }
            ++i;
        }
        return cipherName;
    }

    public synchronized void decodeData(byte[] byteArray) {
        this.decodeData(byteArray, byteArray.length);
    }

    public synchronized void decodeData(byte[] byteArray, int length) {
        if (this.cache.size() == 0) {
            this.setTimestamp();
        }
        this.cache.write(byteArray, 0, length);
        this.checkForCompleteMessage();
    }

    public String getName() {
        return "SSL Decoder";
    }

    public String getVersion() {
        return "V1.0";
    }

    protected String parseDN(byte[] message, int startOffset, int messageLength) {
        String dn = null;
        int setOffset = BerUtilities.dataOffset(message, startOffset);
        int setLength = BerUtilities.getComponentLength(message, setOffset);
        int seqOffset = BerUtilities.dataOffset(message, setOffset);
        while (seqOffset < startOffset + messageLength) {
            int oidOffset = BerUtilities.dataOffset(message, seqOffset);
            int oidLength = BerUtilities.getComponentLength(message, oidOffset);
            Oid oid = new Oid(message, oidOffset, oidLength);
            int valOffset = oidOffset + oidLength;
            String val = BerUtilities.getString(message, valOffset);
            dn = dn == null ? String.valueOf(oid.toString()) + "=" + val : String.valueOf(dn) + ", " + oid.toString() + "=" + val;
            setLength = BerUtilities.getComponentLength(message, setOffset += setLength);
            seqOffset = BerUtilities.dataOffset(message, setOffset);
        }
        return dn;
    }

    protected boolean parseSSL3Alert(byte[] message) {
        if (message.length < 7) {
            return false;
        }
        this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n");
        this.displayMessage("SSLV3_ALERT :\n");
        this.displayMessage("  Version : " + message[1] + "\n");
        int dataBytes = 256 * SSLDecoder.byteToInt(message[3]) + SSLDecoder.byteToInt(message[4]);
        int totalBytes = dataBytes + 5;
        if (dataBytes != 2) {
            this.displayMessage("  ---contents of alert appear to be encrypted\n");
        } else {
            this.displayMessage("  Level   : " + SSLDecoder.byteToInt(message[5]) + " ");
            switch (message[5]) {
                case 1: {
                    this.displayMessage("(warning)\n");
                    break;
                }
                case 2: {
                    this.displayMessage("(fatal)\n");
                    break;
                }
                default: {
                    this.displayMessage("(unrecognized level code)\n");
                }
            }
            this.displayMessage("  Desc.   : ");
            String sp = "Sending party ";
            switch (message[6]) {
                case 0: {
                    this.displayMessage(String.valueOf(sp) + "closing connection\n" + "             (SSL3_AD_CLOSE_NOTIFY");
                    break;
                }
                case 10: {
                    this.displayMessage(String.valueOf(sp) + "received improper message\n" + "             (SSL3_AD_UNEXPECTED_MESSAGE");
                    break;
                }
                case 20: {
                    this.displayMessage(String.valueOf(sp) + "received message that couldn't be authenticated\n" + "             (SSL3_AD_BAD_RECORD_MAC");
                    break;
                }
                case 30: {
                    this.displayMessage(String.valueOf(sp) + "received data it couldn't compress\n" + "             (SSL3_AD_DECOMPRESSION_FAILURE");
                    break;
                }
                case 40: {
                    this.displayMessage(String.valueOf(sp) + "could not negotiate acceptable security\n" + "             (SSL3_AD_HANDSHAKE_FAILURE");
                    break;
                }
                case 41: {
                    this.displayMessage(String.valueOf(sp) + "has no certificate for server's CertificateRequest\n" + "             (SSL3_AD_NO_CERTIFICATE");
                    break;
                }
                case 42: {
                    this.displayMessage(String.valueOf(sp) + "received corrupt certificate\n" + "             (SSL3_AD_BAD_CERTIFICATE");
                    break;
                }
                case 43: {
                    this.displayMessage(String.valueOf(sp) + "received unsupported certificate\n" + "             (SSL3_AD_UNSUPPORTED_CERTIFICATE");
                    break;
                }
                case 44: {
                    this.displayMessage(String.valueOf(sp) + "received certificate that has been revoked\n" + "             (SSL3_AD_CERTIFICATE_REVOKED");
                    break;
                }
                case 45: {
                    this.displayMessage(String.valueOf(sp) + "received certificate that has expired\n" + "             (SSL3_AD_CERTIFICATE_EXPIRED");
                    break;
                }
                case 46: {
                    this.displayMessage(String.valueOf(sp) + "has unspecified problem with certificate it received\n" + "             (SSL3_AD_CERTIFICATE_UNKNOWN");
                    break;
                }
                case 47: {
                    this.displayMessage(String.valueOf(sp) + "received handshake with illegal parameter\n" + "             (SSL3_AD_ILLEGAL_PARAMETER");
                    break;
                }
                case 21: {
                    this.displayMessage(String.valueOf(sp) + "decrypted invalid/illegal message\n" + "             (TLS1_AD_DECRYPTION_FAILED");
                    break;
                }
                case 22: {
                    this.displayMessage(String.valueOf(sp) + "received message > (2^14 + 2048) bytes\n" + "             (TLS1_AD_RECORD_OVERFLOW");
                    break;
                }
                case 48: {
                    this.displayMessage("Sending party could't identify/trust CA of certificate\n             (TLS1_AD_UNKNOWN_CA");
                    break;
                }
                case 49: {
                    this.displayMessage(String.valueOf(sp) + "received certificate with insufficient access rights\n" + "             (TLS1_AD_ACCESS_DENIED");
                    break;
                }
                case 50: {
                    this.displayMessage(String.valueOf(sp) + "couldn't decode message\n" + "             (TLS1_AD_DECODE_ERROR");
                    break;
                }
                case 51: {
                    this.displayMessage(String.valueOf(sp) + "couldn't complete handshake because of decryption error\n" + "             (TLS1_AD_DECRYPT_ERROR");
                    break;
                }
                case 60: {
                    this.displayMessage(String.valueOf(sp) + "detected negotiation parameter contravening U.S. export restrictions\n" + "             (TLS1_AD_EXPORT_RESTRICTION");
                    break;
                }
                case 70: {
                    this.displayMessage(String.valueOf(sp) + "cannot support requested TLS protocol\n" + "             (TLS1_AD_PROTOCOL_VERSION");
                    break;
                }
                case 71: {
                    this.displayMessage(String.valueOf(sp) + "requires cipher suites more secure than client supports\n" + "             (TLS1_AD_INSUFFICIENT_SECURITY");
                    break;
                }
                case 80: {
                    this.displayMessage(String.valueOf(sp) + "had internal error\n" + "             (TLS1_AD_INTERNAL_ERROR");
                    break;
                }
                case 90: {
                    this.displayMessage(String.valueOf(sp) + "wishes to cancel handshake negotiation\n" + "             (TLS1_AD_USER_CANCELLED");
                    break;
                }
                case 100: {
                    this.displayMessage(String.valueOf(sp) + "unable to renegotiate TLS handshake\n" + "             (TLS1_AD_NO_RENEGOTIATION");
                    break;
                }
                default: {
                    this.displayMessage("unknown code (");
                }
            }
            this.displayMessage(" [" + SSLDecoder.byteToInt(message[6]) + "])\n");
        }
        this.cache.reset();
        if (message.length > totalBytes) {
            this.cache.write(message, totalBytes, message.length - totalBytes);
        }
        return true;
    }

    protected boolean parseSSL3ApplicationData(byte[] message) {
        if (message.length < 5) {
            return false;
        }
        int dataBytes = 256 * SSLDecoder.byteToInt(message[3]) + SSLDecoder.byteToInt(message[4]);
        int totalBytes = dataBytes + 5;
        if (message.length < totalBytes) {
            return false;
        }
        this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n");
        this.displayMessage("SSLV3_Application data :\n");
        this.displayMessage("  Version : " + message[2] + "\n");
        this.displayMessage("  Length  : 0x" + Integer.toHexString(dataBytes) + "\n");
        this.cache.reset();
        if (message.length > totalBytes) {
            this.cache.write(message, totalBytes, message.length - totalBytes);
        }
        return true;
    }

    protected boolean parseSSL3ChangeCipherSpec(byte[] message) {
        if (message.length < 6) {
            return false;
        }
        this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n");
        this.displayMessage("SSLV3 Change Cipher Spec :\n");
        this.displayMessage("  Version : " + message[1] + "\n");
        this.displayMessage("  CCS     : " + message[5] + "\n");
        this.cache.reset();
        if (message.length > 6) {
            this.cache.write(message, 6, message.length - 6);
        }
        return true;
    }

    protected boolean parseSSL3Handshake(byte[] message) {
        if (message.length < 5) {
            return false;
        }
        int dataBytes = 256 * SSLDecoder.byteToInt(message[3]) + SSLDecoder.byteToInt(message[4]);
        int totalBytes = dataBytes + 5;
        if (message.length < totalBytes) {
            return false;
        }
        this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n");
        this.displayMessage("SSLV3_HANDSHAKE :\n");
        this.displayMessage("  Version : " + message[2] + "\n");
        this.displayMessage("  Length  : 0x" + Integer.toHexString(dataBytes) + "\n");
        int offset = 5;
        int numHandshakes = 0;
        while (offset < totalBytes) {
            this.displayMessage("  Handshake #" + ++numHandshakes + " :\n");
            byte messageType = message[offset];
            int messageLength = SSLDecoder.byteToInt(message[offset + 1]);
            messageLength = messageLength * 256 + SSLDecoder.byteToInt(message[offset + 2]);
            messageLength = messageLength * 256 + SSLDecoder.byteToInt(message[offset + 3]);
            this.displayMessage("    Handshake type : ");
            switch (messageType) {
                case 0: {
                    this.displayMessage("HelloRequest (SSL3_MT_HELLO_REQUEST)\n");
                    break;
                }
                case 1: {
                    this.displayMessage("ClientHello (SSL3_MT_CLIENT_HELLO)\n");
                    this.parseV3ClientHello(message, offset, messageLength);
                    break;
                }
                case 2: {
                    this.displayMessage("ServerHello (SSL3_MT_SERVER_HELLO)\n");
                    this.parseV3ServerHello(message, offset, messageLength);
                    break;
                }
                case 11: {
                    this.displayMessage("Certificate (SSL3_MT_CERTIFICATE)\n");
                    this.parseV3Certificate(message, offset, messageLength);
                    break;
                }
                case 12: {
                    this.displayMessage("ServerKeyExchange (SSL3_MT_SERVER_KEY_EXCHANGE)\n");
                    this.parseV3ServerKeyExchange(message, offset, messageLength);
                    break;
                }
                case 13: {
                    this.displayMessage("CertificateRequest (SSL3_MT_CERTIFICATE_REQUEST)\n");
                    this.parseV3CertificateRequest(message, offset, messageLength);
                    break;
                }
                case 14: {
                    this.displayMessage("ServerHelloDone (SSL3_MT_SERVER_DONE)\n");
                    break;
                }
                case 15: {
                    this.displayMessage("CertificateVerify (SSL3_MT_CERTIFICATE_VERIFY)\n");
                    this.parseV3CertificateVerify(message, offset, messageLength);
                    break;
                }
                case 16: {
                    this.displayMessage("ClientKeyExchange (SSL3_MT_CLIENT_KEY_EXCHANGE)\n");
                    this.parseV3ClientKeyExchange(message, offset, messageLength);
                    break;
                }
                case 20: {
                    this.displayMessage("Finished (SSL3_MT_FINISHED)\n");
                    break;
                }
                default: {
                    if (dataBytes == 56) {
                        this.displayMessage("Likely to be a compressed/encrypted Finished (SSL3_MT_FINISHED) message\n");
                        break;
                    }
                    this.displayMessage(" unknown handshake type (" + SSLDecoder.byteToInt(messageType) + ")\n");
                }
            }
            int handshakeOffset = offset += 4;
            offset += messageLength;
        }
        this.cache.reset();
        if (message.length > totalBytes) {
            this.cache.write(message, totalBytes, message.length - totalBytes);
        }
        return true;
    }

    protected boolean parseSSLV2Handshake(byte[] message) {
        int messageLen = BerUtilities.getLengthField(message, 1);
        int requiredBytes = BerUtilities.getComponentLength(message, 0);
        if (requiredBytes > message.length) {
            return false;
        }
        this.displayMessage("\n\n" + this.getTimestamp() + " : " + this.decoderName + "\n");
        this.displayMessage("SSLV2_HANDSHAKE :\n");
        int dataOffset = BerUtilities.dataOffset(message, 0);
        int messageType = SSLDecoder.byteToInt(message[dataOffset]);
        switch (messageType) {
            case 1: {
                this.displayMessage("  ClientHello ");
                this.displayMessage(" major-version = " + SSLDecoder.byteToInt(message[dataOffset + 1]) + ", minor-version = " + SSLDecoder.byteToInt(message[dataOffset + 2]) + "\n");
                int cipherSuiteLength = 256 * SSLDecoder.byteToInt(message[dataOffset + 3]) + SSLDecoder.byteToInt(message[dataOffset + 4]);
                int sessionIdLength = 256 * SSLDecoder.byteToInt(message[dataOffset + 5]) + SSLDecoder.byteToInt(message[dataOffset + 6]);
                int challengeLength = 256 * SSLDecoder.byteToInt(message[dataOffset + 7]) + SSLDecoder.byteToInt(message[dataOffset + 8]);
                int cipherSuiteOffset = dataOffset + 9;
                int sessionIdOffset = cipherSuiteOffset + cipherSuiteLength;
                int challengeOffset = sessionIdOffset + sessionIdLength;
                int numCiphers = cipherSuiteLength / 3;
                this.displayMessage("  Client proposes " + numCiphers + " cipher suites :\n");
                int i = 0;
                while (i < numCiphers) {
                    int cipherOffset = cipherSuiteOffset + i * 3;
                    this.displayMessage("     #" + (i + 1) + " : " + SSLDecoder.decodeCipherName(message, cipherOffset, true) + "\n");
                    ++i;
                }
                this.displayMessage("  Session id (size 0x" + Integer.toHexString(sessionIdLength) + ") : \n");
                this.displayMessage(HexDecoder.hexify(message, sessionIdOffset, sessionIdLength, "    "));
                this.displayMessage("  Challenge (size 0x" + Integer.toHexString(challengeLength) + ") :\n");
                this.displayMessage(HexDecoder.hexify(message, challengeOffset, challengeLength, "    "));
                break;
            }
            default: {
                this.displayMessage("Unknown message type : 0x" + Integer.toHexString(messageType) + "\n");
            }
        }
        this.cache.reset();
        if (message.length > requiredBytes) {
            this.cache.write(message, requiredBytes, message.length - requiredBytes);
        }
        return true;
    }

    protected void parseV3Certificate(byte[] message, int startOffset, int messageLength) {
        int certChainLength = SSLDecoder.byteToInt(message[startOffset + 4]);
        certChainLength = certChainLength * 256 + SSLDecoder.byteToInt(message[startOffset + 5]);
        certChainLength = certChainLength * 256 + SSLDecoder.byteToInt(message[startOffset + 6]);
        this.displayMessage("    Certificate chain length : " + certChainLength + "\n");
        int numCerts = 0;
        int certOffset = startOffset + 7;
        while (certOffset < messageLength + startOffset) {
            int certLength = SSLDecoder.byteToInt(message[certOffset]);
            certLength = certLength * 256 + SSLDecoder.byteToInt(message[certOffset + 1]);
            certLength = certLength * 256 + SSLDecoder.byteToInt(message[certOffset + 2]);
            this.displayMessage("      Certificate #" + ++numCerts + " :\n");
            boolean diy = true;
            try {
                byte[] c = new byte[certLength];
                System.arraycopy(message, certOffset + 3, c, 0, certLength);
                X509CertImpl x = new X509CertImpl(c);
                this.displayMessage(x.toString());
                diy = false;
            }
            catch (Exception c) {
                // empty catch block
            }
            if (diy) {
                this.x509 = new X509Certificate(message, certOffset + 3, certLength);
                try {
                    this.displayMessage("        Version : " + this.x509.getVersionNumber() + "\n");
                    this.displayMessage("        Serial #: " + this.x509.getSerialNumber() + "\n");
                    String oid = this.x509.getAlgorithmId().toString();
                    if (oid.equalsIgnoreCase("1.2.840.113549.1.1.4")) {
                        oid = String.valueOf(oid) + " (MD5 with RSA encryption)";
                    }
                    if (oid.equalsIgnoreCase("1.2.840.113549.1.1.1")) {
                        oid = String.valueOf(oid) + " (RSA encryption)";
                    }
                    this.displayMessage("        Signature Algorithm : " + oid + "\n");
                    this.displayMessage("        Issuer  : " + this.x509.getIssuer() + "\n");
                    this.displayMessage("        Validity:\n");
                    this.displayMessage("          Not before " + this.x509.getNotBefore() + "\n");
                    this.displayMessage("          Not after " + this.x509.getNotAfter() + "\n");
                    this.displayMessage("        Subject : " + this.x509.getSubject() + "\n");
                    oid = this.x509.getPkiAlgorithmId().toString();
                    if (oid.equalsIgnoreCase("1.2.840.113549.1.1.4")) {
                        oid = String.valueOf(oid) + " (MD5 with RSA encryption)";
                    }
                    if (oid.equalsIgnoreCase("1.2.840.113549.1.1.1")) {
                        oid = String.valueOf(oid) + " (RSA encryption)";
                    }
                    this.displayMessage("        Subject Public Key Info :\n");
                    this.displayMessage("          PKI algorithm : " + oid + "\n");
                    this.displayMessage("          public key : \n" + this.x509.getSubjectPublicKey() + "\n");
                }
                catch (Exception e) {
                    logger.info("exception " + e);
                    this.displayMessage("\n      Could not decode certificate #" + numCerts + e + "\n      will try dumping ASN.1 :\n");
                    this.displayMessage(ASN1Decoder.decodeTLV(message, certOffset + 3, certOffset + 3 + certLength, 8));
                }
            }
            this.displayMessage("      ==============================================\n");
            certOffset = certOffset + 3 + certLength;
        }
    }

    protected void parseV3CertificateRequest(byte[] message, int startOffset, int messageLength) {
        int ctLen = message[startOffset + 4];
        int casLenOffset = startOffset + 5 + ctLen;
        int casLen = 256 * SSLDecoder.byteToInt(message[casLenOffset]) + SSLDecoder.byteToInt(message[casLenOffset + 1]);
        this.displayMessage("    Number of acceptable certificate types : " + ctLen + "\n");
        int i = 0;
        while (i < ctLen) {
            this.displayMessage("      #" + i + " : ");
            switch (message[5 + i]) {
                case 1: {
                    this.displayMessage("RSA signing and key exchange (SSL3_CT_RSA_SIGN)\n");
                    break;
                }
                case 2: {
                    this.displayMessage("DSA signing only (SSL3_CT_DSS_SIGN)\n");
                    break;
                }
                case 3: {
                    this.displayMessage("RSA signing with fixed Diffie-Hellman key exchange (SSL3_CT_RSA_FIXED_DH)\n");
                    break;
                }
                case 4: {
                    this.displayMessage("DSA signing with fixed Diffie-Hellman key exchange (SSL3_CT_DSS_FIXED_DH)\n");
                    break;
                }
                case 5: {
                    this.displayMessage("RSA signing with ephemeral Diffie-Hellman key exchange (SSL3_CT_RSA_EPHEMERAL_DH)\n");
                    break;
                }
                case 6: {
                    this.displayMessage("DSA signing with ephemeral Diffie-Hellman key exchange (SSL3_CT_DSS_EPHEMERAL_DH)\n");
                    break;
                }
                case 20: {
                    this.displayMessage("Fortezza/DMS signing and key exchange (SSL3_CT_FORTEZZA_DMS)\n");
                    break;
                }
                case 7: {
                    this.displayMessage("SSL3_CT_NUMBER\n");
                    break;
                }
                default: {
                    this.displayMessage("Unknown certificate type (" + message[5 + i] + ")\n");
                }
            }
            ++i;
        }
        int numCAs = 0;
        int caOffset = casLenOffset + 2;
        while (caOffset < messageLength + startOffset) {
            int caLen = 256 * SSLDecoder.byteToInt(message[caOffset]) + SSLDecoder.byteToInt(message[caOffset + 1]);
            this.displayMessage("    CA #" + ++numCAs + " : ");
            try {
                this.displayMessage(String.valueOf(this.parseDN(message, caOffset + 2, caLen)) + "\n");
            }
            catch (Exception e) {
                this.displayMessage("couldn't be parsed (" + e + ")\n");
            }
            caOffset = caOffset + caLen + 2;
        }
    }

    protected void parseV3CertificateVerify(byte[] message, int startOffset, int messageLength) {
        switch (messageLength) {
            case 16: {
                this.displayMessage("    MD5 hash : ");
                int i = 0;
                while (i < 16) {
                    this.displayMessage(String.valueOf(BerUtilities.byteToHex(message[startOffset + i + 4])) + " ");
                    ++i;
                }
                this.displayMessage("\n");
                break;
            }
            case 20: {
                this.displayMessage("    SHA hash : ");
                int i = 0;
                while (i < 20) {
                    this.displayMessage(String.valueOf(BerUtilities.byteToHex(message[startOffset + i + 4])) + " ");
                    ++i;
                }
                this.displayMessage("\n");
                break;
            }
            default: {
                this.displayMessage("    Unknown hash type (length = " + messageLength + ")\n");
            }
        }
    }

    protected void parseV3ClientHello(byte[] message, int startOffset, int messageLength) {
        int c;
        this.displayMessage("    Version         : " + message[startOffset + 4] + "\n");
        this.displayMessage("    client rand val : ");
        int i = 0;
        while (i < 32) {
            this.displayMessage(BerUtilities.byteToHex(message[startOffset + i + 6]));
            ++i;
        }
        this.displayMessage("\n");
        int sessionIdLen = SSLDecoder.byteToInt(message[startOffset + 38]);
        int sessionIdOffset = startOffset + 39;
        int cslOffset = sessionIdOffset + sessionIdLen;
        int cipherOffset = cslOffset + 2;
        int cipherSuiteLength = 256 * SSLDecoder.byteToInt(message[cslOffset]) + SSLDecoder.byteToInt(message[cslOffset + 1]);
        int cmpLenOffset = cipherOffset + cipherSuiteLength;
        int cmpLen = SSLDecoder.byteToInt(message[cmpLenOffset]);
        this.displayMessage("    Session id (size 0x" + Integer.toHexString(sessionIdLen) + ") :\n");
        this.displayMessage(HexDecoder.hexify(message, sessionIdOffset, sessionIdLen, "    "));
        int numCiphers = cipherSuiteLength / 2;
        this.displayMessage("    Client proposes " + numCiphers + " cipher suites :\n");
        int i2 = 0;
        while (i2 < numCiphers) {
            c = cipherOffset + i2 * 2;
            this.displayMessage("      #" + (i2 + 1) + " : " + SSLDecoder.decodeCipherName(message, c, false) + "\n");
            ++i2;
        }
        this.displayMessage("    Client proposes " + cmpLen + " compression methods\n");
        i2 = 0;
        while (i2 < cmpLen) {
            c = SSLDecoder.byteToInt(message[i2 + cmpLen + 1]);
            this.displayMessage("      #" + (i2 + 1) + " : " + c + "\n");
            ++i2;
        }
    }

    protected void parseV3ClientKeyExchange(byte[] message, int startOffset, int messageLength) {
        this.displayMessage("    Length of data : " + messageLength + " bytes\n");
    }

    protected void parseV3ServerHello(byte[] message, int startOffset, int messageLength) {
        this.displayMessage("    Version         : " + message[startOffset + 4] + "\n");
        this.displayMessage("    server rand val : ");
        int i = 0;
        while (i < 32) {
            this.displayMessage(String.valueOf(BerUtilities.byteToHex(message[startOffset + i + 6])) + " ");
            ++i;
        }
        this.displayMessage("\n");
        int sessionIdLen = SSLDecoder.byteToInt(message[startOffset + 38]);
        int sessionIdOffset = startOffset + 39;
        int cipherOffset = sessionIdOffset + sessionIdLen;
        int cmpOffset = cipherOffset + 2;
        this.displayMessage("    Session id (size 0x" + Integer.toHexString(sessionIdLen) + ") :\n");
        this.displayMessage(HexDecoder.hexify(message, sessionIdOffset, sessionIdLen, "   "));
        this.displayMessage("    Server chooses cipher : " + SSLDecoder.decodeCipherName(message, cipherOffset, false) + "\n");
        this.displayMessage("    Server chooses compression : " + SSLDecoder.byteToInt(message[cmpOffset]) + "\n");
    }

    protected void parseV3ServerKeyExchange(byte[] message, int startOffset, int messageLength) {
        this.displayMessage("    message format depends on cryptographic algorithms being used\n");
        this.displayMessage("    --- at present, full decoding of ServerKeyExchange is NYI\n");
    }
}

