/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.CDPProxy;
import com.nickoh.snooper.Decoder;
import com.nickoh.util.Dates;
import com.nickoh.util.NickohLogHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SnooperGui
extends JPanel {
    private static final String moduleVersion = "2.0-1";
    private static Logger logger = NickohLogHandler.getLogger();
    private JPanel ivjcenterPanel = null;
    private JComboBox ivjdecoderCombo = null;
    private JLabel ivjJLabel1 = null;
    private JLabel ivjJLabel2 = null;
    private JLabel ivjJLabel3 = null;
    private JLabel ivjJLabel4 = null;
    private JTextField ivjlistenPortTextField = null;
    private JPanel ivjnorthPanel = null;
    private JTextField ivjserverNameTextField = null;
    private JTextField ivjserverPortTextField = null;
    private JButton ivjstartStopButton = null;
    private static Class[] decoders;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private boolean snoopIsRunning = false;
    private JTabbedPane ivjJTabbedPane1 = null;
    protected CDPProxy proxy = null;
    private JPanel ivjcenterInputPanel = null;
    private JPanel ivjciInput = null;
    private GridLayout ivjciInputGridLayout = null;
    private JPanel ivjciLabels = null;
    private GridLayout ivjciLabelsGridLayout = null;
    private JPanel ivjeastInputPanel = null;
    private JPanel ivjeiInput = null;
    private GridLayout ivjeiInputGridLayout = null;
    private JPanel ivjeiLabels = null;
    private GridLayout ivjeiLabelsGridLayout = null;
    private JPanel ivjinputPanel = null;
    private GridLayout ivjeastInputPanelGridLayout = null;
    private JPanel ivjoptionsPanel = null;
    protected JPanel decoderOptionsPanel = null;
    private JPanel ivjsouthPanel = null;
    private JPanel ivjstartStopButtonPanel = null;
    private JPanel ivjstatusPanel = null;
    private JLabel ivjsnoopingLabel = null;
    private Thread animatorThread = null;
    private JFrame parentFrame = null;
    public static final String myClassName = "SnooperGUI";
    private JLabel ivjfillerLabel = null;
    private String versionString = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class[] classArray = new Class[5];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.nickoh.snooper.HexDecoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.nickoh.snooper.ASN1Decoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.nickoh.snooper.LDAPDecoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("com.nickoh.snooper.SSLDecoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("com.nickoh.snooper.RFC1006Decoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        decoders = classArray;
    }

    public SnooperGui() {
        this.initialize();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.decoderCombo_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void createAnimator() {
        String labelText = "        ";
        String emptyText = "        ";
        String temp = "";
        if (this.parentFrame != null) {
            temp = this.parentFrame.getTitle();
        }
        final String originalCaption = temp;
        if (this.animatorThread != null) {
            if (this.animatorThread.isAlive()) {
                this.animatorThread.interrupt();
            }
            this.animatorThread = null;
        }
        this.animatorThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    int offset = 0;
                    do {
                        String tempLabel = "        ";
                        int capOffset = offset % SnooperGui.myClassName.length();
                        String tempCaption = SnooperGui.myClassName.substring(capOffset, SnooperGui.myClassName.length());
                        tempCaption = String.valueOf(tempCaption) + SnooperGui.myClassName.substring(0, capOffset);
                        tempCaption = String.valueOf(tempCaption) + " " + SnooperGui.this.getVersion();
                        String newLabel = tempLabel;
                        String newCaption = tempCaption;
                        SwingUtilities.invokeLater(new Runnable(this, newCaption, newLabel){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ String val$newCaption;
                            private final /* synthetic */ String val$newLabel;
                            {
                                this.this$1 = var1_1;
                                this.val$newCaption = string;
                                this.val$newLabel = string2;
                            }

                            public void run() {
                                if (SnooperGui.access$5(1.access$0(this.this$1)) != null) {
                                    SnooperGui.access$5(1.access$0(this.this$1)).setTitle(this.val$newCaption);
                                }
                                SnooperGui.access$4(1.access$0(this.this$1)).setText(this.val$newLabel);
                            }
                        });
                        ++offset;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            Object var7_8 = null;
                            SwingUtilities.invokeLater(new Runnable(this, originalCaption){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ String val$originalCaption;
                                {
                                    this.this$1 = var1_1;
                                    this.val$originalCaption = string;
                                }

                                public void run() {
                                    SnooperGui.access$4(1.access$0(this.this$1)).setText("          ");
                                    if (SnooperGui.access$5(1.access$0(this.this$1)) != null) {
                                        SnooperGui.access$5(1.access$0(this.this$1)).setTitle(this.val$originalCaption);
                                    }
                                    1.access$0(this.this$1).revalidate();
                                    1.access$0(this.this$1).repaint();
                                }
                            });
                            return;
                        }
                    } while (SnooperGui.this.snoopIsRunning);
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                {
                    Object var7_10 = null;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }

            static /* synthetic */ SnooperGui access$0(1 var0) {
                return var0.SnooperGui.this;
            }
        });
        this.animatorThread.setPriority(1);
        this.animatorThread.setDaemon(true);
        this.animatorThread.start();
    }

    public void decoderCombo_ActionPerformed(ActionEvent actionEvent) {
        this.showDecoderOptions();
    }

    private JPanel getcenterInputPanel() {
        if (this.ivjcenterInputPanel == null) {
            try {
                this.ivjcenterInputPanel = new JPanel();
                this.ivjcenterInputPanel.setName("centerInputPanel");
                this.ivjcenterInputPanel.setLayout(new BorderLayout());
                this.getcenterInputPanel().add((Component)this.getciLabels(), "West");
                this.getcenterInputPanel().add((Component)this.getciInput(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjcenterInputPanel;
    }

    private JPanel getcenterPanel() {
        if (this.ivjcenterPanel == null) {
            try {
                this.ivjcenterPanel = new JPanel();
                this.ivjcenterPanel.setName("centerPanel");
                this.ivjcenterPanel.setLayout(new BorderLayout());
                this.getcenterPanel().add((Component)this.getJTabbedPane1(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjcenterPanel;
    }

    private JPanel getciInput() {
        if (this.ivjciInput == null) {
            try {
                this.ivjciInput = new JPanel();
                this.ivjciInput.setName("ciInput");
                this.ivjciInput.setLayout(this.getciInputGridLayout());
                this.getciInput().add((Component)this.getserverNameTextField(), this.getserverNameTextField().getName());
                this.getciInput().add((Component)this.getdecoderCombo(), this.getdecoderCombo().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjciInput;
    }

    private GridLayout getciInputGridLayout() {
        GridLayout ivjciInputGridLayout = null;
        try {
            ivjciInputGridLayout = new GridLayout(0, 1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjciInputGridLayout;
    }

    private JPanel getciLabels() {
        if (this.ivjciLabels == null) {
            try {
                this.ivjciLabels = new JPanel();
                this.ivjciLabels.setName("ciLabels");
                this.ivjciLabels.setLayout(this.getciLabelsGridLayout());
                this.getciLabels().add((Component)this.getJLabel1(), this.getJLabel1().getName());
                this.getciLabels().add((Component)this.getJLabel4(), this.getJLabel4().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjciLabels;
    }

    private GridLayout getciLabelsGridLayout() {
        GridLayout ivjciLabelsGridLayout = null;
        try {
            ivjciLabelsGridLayout = new GridLayout(0, 1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjciLabelsGridLayout;
    }

    private JComboBox getdecoderCombo() {
        if (this.ivjdecoderCombo == null) {
            try {
                this.ivjdecoderCombo = new JComboBox();
                this.ivjdecoderCombo.setName("decoderCombo");
                this.ivjdecoderCombo.setFont(new Font("dialog", 0, 14));
                int i = 0;
                while (i < decoders.length) {
                    Class decoderClass = decoders[i];
                    Decoder d = (Decoder)decoderClass.newInstance();
                    String fullName = String.valueOf(d.getName()) + "  " + d.getVersion();
                    this.ivjdecoderCombo.addItem(fullName);
                    ++i;
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjdecoderCombo;
    }

    private JPanel getdecoderOptionsPanel() {
        if (this.decoderOptionsPanel == null) {
            try {
                this.decoderOptionsPanel = new JPanel();
                this.decoderOptionsPanel.setName("decoderOptionsPanel");
                this.decoderOptionsPanel.setLayout(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.decoderOptionsPanel;
    }

    private JPanel geteastInputPanel() {
        if (this.ivjeastInputPanel == null) {
            try {
                this.ivjeastInputPanel = new JPanel();
                this.ivjeastInputPanel.setName("eastInputPanel");
                this.ivjeastInputPanel.setLayout(this.geteastInputPanelGridLayout());
                this.geteastInputPanel().add((Component)this.geteiLabels(), this.geteiLabels().getName());
                this.geteastInputPanel().add((Component)this.geteiInput(), this.geteiInput().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjeastInputPanel;
    }

    private GridLayout geteastInputPanelGridLayout() {
        GridLayout ivjeastInputPanelGridLayout = null;
        try {
            ivjeastInputPanelGridLayout = new GridLayout(0, 2);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjeastInputPanelGridLayout;
    }

    private JPanel geteiInput() {
        if (this.ivjeiInput == null) {
            try {
                this.ivjeiInput = new JPanel();
                this.ivjeiInput.setName("eiInput");
                this.ivjeiInput.setLayout(this.geteiInputGridLayout());
                this.geteiInput().add((Component)this.getserverPortTextField(), this.getserverPortTextField().getName());
                this.geteiInput().add((Component)this.getlistenPortTextField(), this.getlistenPortTextField().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjeiInput;
    }

    private GridLayout geteiInputGridLayout() {
        GridLayout ivjeiInputGridLayout = null;
        try {
            ivjeiInputGridLayout = new GridLayout(0, 1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjeiInputGridLayout;
    }

    private JPanel geteiLabels() {
        if (this.ivjeiLabels == null) {
            try {
                this.ivjeiLabels = new JPanel();
                this.ivjeiLabels.setName("eiLabels");
                this.ivjeiLabels.setLayout(this.geteiLabelsGridLayout());
                this.geteiLabels().add((Component)this.getJLabel2(), this.getJLabel2().getName());
                this.geteiLabels().add((Component)this.getJLabel3(), this.getJLabel3().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjeiLabels;
    }

    private GridLayout geteiLabelsGridLayout() {
        GridLayout ivjeiLabelsGridLayout = null;
        try {
            ivjeiLabelsGridLayout = new GridLayout(0, 1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjeiLabelsGridLayout;
    }

    private JLabel getfillerLabel() {
        if (this.ivjfillerLabel == null) {
            try {
                this.ivjfillerLabel = new JLabel();
                this.ivjfillerLabel.setName("fillerLabel");
                this.ivjfillerLabel.setFont(new Font("monospaced", 0, 12));
                this.ivjfillerLabel.setText("          ");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjfillerLabel;
    }

    private JPanel getinputPanel() {
        if (this.ivjinputPanel == null) {
            try {
                this.ivjinputPanel = new JPanel();
                this.ivjinputPanel.setName("inputPanel");
                this.ivjinputPanel.setLayout(new BorderLayout());
                this.getinputPanel().add((Component)this.getcenterInputPanel(), "Center");
                this.getinputPanel().add((Component)this.geteastInputPanel(), "East");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjinputPanel;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setToolTipText("The name of the system where the server is running");
                this.ivjJLabel1.setFont(new Font("dialog", 0, 12));
                this.ivjJLabel1.setText("  Server Name : ");
                this.ivjJLabel1.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setToolTipText("     The port number that the server is listening on");
                this.ivjJLabel2.setText("        Server Port : ");
                this.ivjJLabel2.setFont(new Font("dialog", 0, 12));
                this.ivjJLabel2.setEnabled(true);
                this.ivjJLabel2.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setToolTipText("The port number that this program should listen on");
                this.ivjJLabel3.setFont(new Font("dialog", 0, 12));
                this.ivjJLabel3.setText("        Listen port  : ");
                this.ivjJLabel3.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel4() {
        if (this.ivjJLabel4 == null) {
            try {
                this.ivjJLabel4 = new JLabel();
                this.ivjJLabel4.setName("JLabel4");
                this.ivjJLabel4.setFont(new Font("dialog", 0, 12));
                this.ivjJLabel4.setText("  Decoder type : ");
                this.ivjJLabel4.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel4;
    }

    private JTabbedPane getJTabbedPane1() {
        if (this.ivjJTabbedPane1 == null) {
            try {
                this.ivjJTabbedPane1 = new JTabbedPane();
                this.ivjJTabbedPane1.setName("JTabbedPane1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTabbedPane1;
    }

    private JTextField getlistenPortTextField() {
        if (this.ivjlistenPortTextField == null) {
            try {
                this.ivjlistenPortTextField = new JTextField();
                this.ivjlistenPortTextField.setName("listenPortTextField");
                this.ivjlistenPortTextField.setToolTipText("The port number that this program should listen on");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlistenPortTextField;
    }

    private JPanel getnorthPanel() {
        if (this.ivjnorthPanel == null) {
            try {
                this.ivjnorthPanel = new JPanel();
                this.ivjnorthPanel.setName("northPanel");
                this.ivjnorthPanel.setLayout(new BorderLayout());
                this.getnorthPanel().add((Component)this.getinputPanel(), "Center");
                this.getnorthPanel().add((Component)this.getsouthPanel(), "South");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjnorthPanel;
    }

    private JPanel getoptionsPanel() {
        if (this.ivjoptionsPanel == null) {
            try {
                this.ivjoptionsPanel = new JPanel();
                this.ivjoptionsPanel.setName("optionsPanel");
                this.ivjoptionsPanel.setLayout(new BorderLayout());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjoptionsPanel;
    }

    private JTextField getserverNameTextField() {
        if (this.ivjserverNameTextField == null) {
            try {
                this.ivjserverNameTextField = new JTextField();
                this.ivjserverNameTextField.setName("serverNameTextField");
                this.ivjserverNameTextField.setToolTipText("The name of the system where the server is running");
                this.ivjserverNameTextField.setText("");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjserverNameTextField;
    }

    private JTextField getserverPortTextField() {
        if (this.ivjserverPortTextField == null) {
            try {
                this.ivjserverPortTextField = new JTextField();
                this.ivjserverPortTextField.setName("serverPortTextField");
                this.ivjserverPortTextField.setToolTipText("The port number that the server is listening on");
                this.ivjserverPortTextField.setText("");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjserverPortTextField;
    }

    private JLabel getsnoopingLabel() {
        if (this.ivjsnoopingLabel == null) {
            try {
                this.ivjsnoopingLabel = new JLabel();
                this.ivjsnoopingLabel.setName("snoopingLabel");
                this.ivjsnoopingLabel.setFont(new Font("monospaced", 0, 12));
                this.ivjsnoopingLabel.setText("          ");
                this.ivjsnoopingLabel.setForeground(Color.red);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjsnoopingLabel;
    }

    private JPanel getsouthPanel() {
        if (this.ivjsouthPanel == null) {
            try {
                this.ivjsouthPanel = new JPanel();
                this.ivjsouthPanel.setName("southPanel");
                this.ivjsouthPanel.setLayout(new BorderLayout());
                this.getsouthPanel().add((Component)this.getoptionsPanel(), "Center");
                this.getsouthPanel().add((Component)this.getstatusPanel(), "South");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjsouthPanel;
    }

    private JButton getstartStopButton() {
        if (this.ivjstartStopButton == null) {
            try {
                this.ivjstartStopButton = new JButton();
                this.ivjstartStopButton.setName("startStopButton");
                this.ivjstartStopButton.setFont(new Font("Arial", 1, 14));
                this.ivjstartStopButton.setText("Start");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjstartStopButton;
    }

    private JPanel getstartStopButtonPanel() {
        if (this.ivjstartStopButtonPanel == null) {
            try {
                this.ivjstartStopButtonPanel = new JPanel();
                this.ivjstartStopButtonPanel.setName("startStopButtonPanel");
                this.ivjstartStopButtonPanel.setLayout(new FlowLayout());
                this.getstartStopButtonPanel().add((Component)this.getstartStopButton(), this.getstartStopButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjstartStopButtonPanel;
    }

    private JPanel getstatusPanel() {
        if (this.ivjstatusPanel == null) {
            try {
                this.ivjstatusPanel = new JPanel();
                this.ivjstatusPanel.setName("statusPanel");
                this.ivjstatusPanel.setLayout(new BorderLayout());
                this.getstatusPanel().add((Component)this.getfillerLabel(), "West");
                this.getstatusPanel().add((Component)this.getstartStopButtonPanel(), "Center");
                this.getstatusPanel().add((Component)this.getsnoopingLabel(), "East");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjstatusPanel;
    }

    public String getVersion() {
        if (this.versionString != null) {
            return this.versionString;
        }
        this.versionString = "v2.0-1";
        Class<?> myClass = this.getClass();
        ClassLoader myClassLoader = myClass.getClassLoader();
        URL url = myClassLoader.getResource("com/nickoh/snooper/SnooperGui.class");
        if (url.toString().startsWith("jar:")) {
            String filename = url.getFile();
            int bang = filename.indexOf("!");
            String className = filename.substring(bang + 2);
            String jarFileName = filename.substring(0, bang);
            if (jarFileName.startsWith("file:")) {
                jarFileName = jarFileName.substring(5);
            }
            try {
                JarFile jf = new JarFile(jarFileName);
                ZipEntry ze = jf.getEntry(className);
                Date date = new Date(ze.getTime());
                this.versionString = String.valueOf(this.versionString) + " built at " + Dates.VMSDate(date);
            }
            catch (IOException e) {
                this.versionString = String.valueOf(this.versionString) + " build date unknown";
                logger.info("Can't get build date : " + e);
                logger.info("jarFileName = " + jarFileName);
                logger.info("classname   = " + className);
            }
        } else {
            this.versionString = String.valueOf(this.versionString) + " build date unknown";
            logger.info("Not running from jar file");
        }
        return this.versionString;
    }

    private void handleException(Throwable exception) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        exception.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getstartStopButton().addActionListener(this.ivjEventHandler);
        this.getdecoderCombo().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("Snooper");
            this.setLayout(new BorderLayout());
            this.setSize(756, 497);
            this.add((Component)this.getnorthPanel(), "North");
            this.add((Component)this.getcenterPanel(), "Center");
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.showDecoderOptions();
        this.makeUIConsistent();
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.WARNING);
        }
        logger.log(Level.INFO, "SnooperGui is initializing");
        try {
            JFrame frame = new JFrame();
            SnooperGui aSnooperGui = new SnooperGui();
            aSnooperGui.setParentFrame(frame);
            frame.setContentPane(aSnooperGui);
            frame.setSize(aSnooperGui.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setTitle("SnooperGUI " + aSnooperGui.getVersion());
            frame.setLocation(200, 200);
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            exception.printStackTrace(System.out);
        }
    }

    protected void makeUIConsistent() {
        this.getstartStopButton().setText(this.snoopIsRunning ? "Abort connections and stop listening" : "Start listening for clients");
        this.getstartStopButton().setForeground(this.snoopIsRunning ? Color.red : new Color(0, 160, 0));
        this.getserverNameTextField().setEnabled(!this.snoopIsRunning);
        this.getserverPortTextField().setEnabled(!this.snoopIsRunning);
        this.getlistenPortTextField().setEnabled(!this.snoopIsRunning);
        this.getdecoderCombo().setEnabled(!this.snoopIsRunning);
    }

    public void setParentFrame(JFrame frame) {
        this.parentFrame = frame;
    }

    protected void showDecoderOptions() {
        this.getoptionsPanel().removeAll();
        this.getoptionsPanel().setBorder(new EmptyBorder(0, 0, 0, 0));
        int decoderId = this.getdecoderCombo().getSelectedIndex();
        Class decoderClass = decoders[decoderId];
        try {
            int defaultPort;
            Decoder d = (Decoder)decoderClass.newInstance();
            JPanel decoderOptionsPanel = d.getOptionsPanel();
            if (decoderOptionsPanel != null) {
                this.getoptionsPanel().add((Component)decoderOptionsPanel, "Center");
                BevelBorder eb = new BevelBorder(0);
                TitledBorder tb = new TitledBorder(eb, String.valueOf(d.getName()) + " options");
                tb.setTitleColor(Color.blue);
                tb.setTitleJustification(2);
                this.getoptionsPanel().setBorder(tb);
            }
            if ((defaultPort = d.getDefaultPort()) != -1) {
                if (this.getserverPortTextField().getText().length() == 0) {
                    this.getserverPortTextField().setText(Integer.toString(defaultPort));
                }
                if (this.getlistenPortTextField().getText().length() == 0) {
                    this.getlistenPortTextField().setText(Integer.toString(defaultPort));
                }
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    protected void startSnooping() {
        if (this.snoopIsRunning) {
            throw new RuntimeException("startSnooping called when snoop already running");
        }
        String serverName = this.getserverNameTextField().getText();
        int serverPort = -1;
        int listenPort = -1;
        try {
            serverPort = Integer.parseInt(this.getserverPortTextField().getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid information for server port : " + e, "Can't create snooper", 0);
            return;
        }
        try {
            listenPort = Integer.parseInt(this.getlistenPortTextField().getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid information for listen port : " + e, "Can't create snooper", 0);
            return;
        }
        int decoder = this.getdecoderCombo().getSelectedIndex();
        Class decoderClass = decoders[decoder];
        try {
            this.proxy = new CDPProxy(InetAddress.getByName(serverName), serverPort, listenPort, this.getJTabbedPane1(), decoderClass);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to create pseudo-server : " + e, "Can't create snooper", 0);
            return;
        }
        Thread t = new Thread(this.proxy);
        t.setDaemon(true);
        t.start();
        this.snoopIsRunning = t.isAlive();
        this.createAnimator();
        this.makeUIConsistent();
    }

    public void startStopButton_Clicked(ActionEvent actionEvent) {
        if (this.snoopIsRunning) {
            this.stopSnooping();
        } else {
            this.startSnooping();
        }
    }

    private void startStopButtonConnection(ActionEvent arg1) {
        try {
            this.startStopButton_Clicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    protected void stopSnooping() {
        if (!this.snoopIsRunning) {
            throw new RuntimeException("stopSnooping called when snoop not running");
        }
        this.proxy.shutdown();
        this.snoopIsRunning = false;
        this.makeUIConsistent();
    }

    static /* synthetic */ JLabel access$4(SnooperGui snooperGui) {
        return snooperGui.getsnoopingLabel();
    }

    static /* synthetic */ JFrame access$5(SnooperGui snooperGui) {
        return snooperGui.parentFrame;
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SnooperGui.this.getstartStopButton()) {
                SnooperGui.this.startStopButtonConnection(e);
            }
            if (e.getSource() == SnooperGui.this.getdecoderCombo()) {
                SnooperGui.this.connEtoC1(e);
            }
        }
    }
}

