/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.asn.BerUtilities;
import com.nickoh.snooper.ConformanceException;
import com.nickoh.snooper.HexDecoder;
import com.nickoh.util.NickohLogHandler;
import java.util.logging.Logger;

public class TPDU {
    private static String moduleVersion = "1.0";
    private static Logger logger = NickohLogHandler.getLogger();
    protected byte[] data = null;
    protected int li = -1;
    protected int tpduCode = -1;
    protected int variablePos = -1;
    protected int variableLen = -1;
    protected int userDataPos = -1;
    protected int userDataLen = -1;
    protected int dstRef = -1;
    protected int srcRef = -1;
    protected int classOptions = -1;
    protected int reason = -1;
    protected int rejectCause = -1;
    protected String tpduName = null;
    public static final int CC = 208;
    public static final int CR = 224;
    public static final int DR = 128;
    public static final int DT = 240;
    public static final int ER = 112;
    private String violations = "";
    private int nreot = -1;

    public TPDU(byte[] byteArray, int startPos, int length) throws ArrayIndexOutOfBoundsException, ConformanceException {
        if (byteArray == null) {
            throw new ArrayIndexOutOfBoundsException("empty array");
        }
        this.li = byteArray[startPos] & 0xFF;
        if (this.li + 1 > length) {
            throw new ArrayIndexOutOfBoundsException("length too big");
        }
        this.data = new byte[length];
        System.arraycopy(byteArray, startPos, this.data, 0, length);
        this.tpduCode = this.data[1] & 0xFF;
        switch (this.tpduCode) {
            case 224: {
                this.decodeHeaderCR();
                this.tpduName = "Connection Request (CR) X.224 \u00a713.3";
                break;
            }
            case 208: {
                this.decodeHeaderCC();
                this.tpduName = "Connection Confirm (CC) X.224 \u00a713.4";
                break;
            }
            case 128: {
                this.decodeHeaderDR();
                this.tpduName = "Disconnect Request (DR) X.224 \u00a713.5";
                break;
            }
            case 240: {
                this.decodeHeaderDT();
                this.tpduName = "Data (DT) X.224 \u00a713.7";
                break;
            }
            case 112: {
                this.decodeHeaderER();
                this.tpduName = "Error (ER) X.224 \u00a713.12";
                break;
            }
            default: {
                throw new ConformanceException("X.224", "13", "Invalid TPDU type for class 0");
            }
        }
        if (this.violations.length() != 0) {
            throw new ConformanceException(this.violations);
        }
    }

    private void decodeHeaderCC() {
        this.dstRef = (this.data[2] & 0xFF) * 256;
        this.dstRef += this.data[3] & 0xFF;
        this.srcRef = (this.data[4] & 0xFF) * 256;
        this.srcRef += this.data[5] & 0xFF;
        this.classOptions = this.data[6] & 0xFF;
        this.variablePos = 7;
        this.variableLen = this.li - 7;
        if (this.data.length > this.li + 1) {
            this.violations = String.valueOf(this.violations) + ConformanceException.message("X.224", "13.4.5", "No user data permitted for class 0 CC") + "\n";
        }
    }

    private void decodeHeaderCR() {
        this.dstRef = (this.data[2] & 0xFF) * 256;
        this.dstRef += this.data[3] & 0xFF;
        this.srcRef = (this.data[4] & 0xFF) * 256;
        this.srcRef += this.data[5] & 0xFF;
        this.classOptions = this.data[6] & 0xFF;
        this.variablePos = 7;
        this.variableLen = this.li - 7;
        if (this.data.length > this.li + 1) {
            this.violations = String.valueOf(this.violations) + ConformanceException.message("X.224", "13.3.5", "No user data permitted for class 0 CR") + "\n";
        }
    }

    private void decodeHeaderDR() {
        this.dstRef = (this.data[2] & 0xFF) * 256;
        this.dstRef += this.data[3] & 0xFF;
        this.srcRef = (this.data[4] & 0xFF) * 256;
        this.srcRef += this.data[5] & 0xFF;
        this.reason = this.data[6] & 0xFF;
        this.variablePos = 7;
        this.variableLen = this.li - 7;
        if (this.data.length > this.li + 1) {
            this.violations = String.valueOf(this.violations) + ConformanceException.message("X.224", "13.5.5", "No user data permitted for class 0 DR") + "\n";
        }
    }

    private void decodeHeaderDT() {
        this.nreot = this.data[2] & 0xFF;
        this.userDataPos = 3;
        this.userDataLen = this.data.length - 3;
    }

    private void decodeHeaderER() {
        this.dstRef = (this.data[2] & 0xFF) * 256;
        this.dstRef += this.data[3] & 0xFF;
        this.rejectCause = this.data[4] & 0xFF;
        this.variablePos = 5;
        this.variableLen = this.li - 5;
    }

    public String formatHeader(String prefix) {
        String retval = String.valueOf(prefix) + this.tpduName + " TPDU :\n";
        prefix = String.valueOf(prefix) + "  ";
        if (this.nreot != -1) {
            retval = String.valueOf(retval) + prefix + "Is EOT       = " + ((this.nreot & 0x80) != 0) + "\n";
        }
        if (this.dstRef != -1) {
            retval = String.valueOf(retval) + prefix + "DST-REF      = 0x" + Integer.toHexString(this.dstRef);
            if (this.tpduCode == 224 && this.dstRef != 0) {
                retval = String.valueOf(retval) + ConformanceException.message("X.224", "13.3.3", "DST-REF should be zero");
            }
            retval = String.valueOf(retval) + "\n";
        }
        if (this.srcRef != -1) {
            retval = String.valueOf(retval) + prefix + "SRC-REF      = 0x" + Integer.toHexString(this.srcRef) + "\n";
        }
        if (this.classOptions != -1) {
            int preferredClass = this.classOptions / 16;
            retval = String.valueOf(retval) + prefix + "CLASS        = " + preferredClass;
            if (preferredClass != 0) {
                retval = String.valueOf(retval) + ConformanceException.message("X.224", "13.3.3", "CLASS field should be 0");
            }
            retval = String.valueOf(retval) + "\n";
            int options = this.classOptions & 0xF;
            retval = String.valueOf(retval) + "  OPTIONS = " + options;
            if (options != 0) {
                retval = String.valueOf(retval) + ConformanceException.message("X.224", "13,3,3", "OPTIONS field should be 0");
            }
            retval = String.valueOf(retval) + "\n";
        }
        if (this.reason != -1) {
            retval = String.valueOf(retval) + prefix + "REASON       = 0x" + Integer.toHexString(this.reason) + " (";
            switch (this.reason) {
                case 0: {
                    retval = String.valueOf(retval) + "Not specified";
                    break;
                }
                case 1: {
                    retval = String.valueOf(retval) + "Congestion at TSAP";
                    break;
                }
                case 2: {
                    retval = String.valueOf(retval) + "Session entity not attached to TSAP";
                    break;
                }
                case 3: {
                    retval = String.valueOf(retval) + "Address unknown";
                    break;
                }
                default: {
                    retval = String.valueOf(retval) + ConformanceException.message("X.224", "13.5.3d", "Invalid reason for class 0");
                }
            }
            retval = String.valueOf(retval) + ")\n";
        }
        if (this.rejectCause != -1) {
            retval = String.valueOf(retval) + prefix + "Reject cause = 0x" + Integer.toHexString(this.reason) + " (";
            switch (this.reason) {
                case 0: {
                    retval = String.valueOf(retval) + "Reason not specified";
                    break;
                }
                case 1: {
                    retval = String.valueOf(retval) + "Invalid parameter code";
                    break;
                }
                case 2: {
                    retval = String.valueOf(retval) + "Invalid TPDU type";
                    break;
                }
                case 3: {
                    retval = String.valueOf(retval) + "Invalid parameter type";
                    break;
                }
                default: {
                    retval = String.valueOf(retval) + ConformanceException.message("X.224", "13.12.3", "Invalid reject cause");
                }
            }
            retval = String.valueOf(retval) + ")\n";
        }
        retval = String.valueOf(retval) + this.formatVariablePart(prefix);
        return retval;
    }

    private String formatVariablePart(String prefix) {
        if (this.variablePos == -1) {
            return "";
        }
        String retval = String.valueOf(prefix) + "Variable part:\n";
        prefix = String.valueOf(prefix) + "  ";
        if (this.variableLen <= 0) {
            retval = String.valueOf(retval) + prefix + "<no variable part>\n";
            return retval;
        }
        int paramNum = 0;
        int offset = this.getParamOffset(paramNum);
        while (offset != -1) {
            int parameterCode = this.data[offset] & 0xFF;
            int parameterLength = this.data[offset + 1] & 0xFF;
            retval = String.valueOf(retval) + prefix + "parameter #" + paramNum + " : ";
            if (this.tpduCode == 224 || this.tpduCode == 208) {
                switch (parameterCode) {
                    case 194: {
                        retval = String.valueOf(retval) + "ID of called TSAP = \"" + BerUtilities.getString(this.data, offset) + "\"\n";
                        break;
                    }
                    case 193: {
                        retval = String.valueOf(retval) + "ID of calling TSAP = \"" + BerUtilities.getString(this.data, offset) + "\"\n";
                        break;
                    }
                    case 192: {
                        retval = String.valueOf(retval) + "proposed max TPDU size = ";
                        int sizeCode = this.data[offset + 2] & 0xFF;
                        switch (sizeCode) {
                            case 13: {
                                retval = String.valueOf(retval) + "8192 " + ConformanceException.message("X.224", "13.3.4b", "not allowed in class 0");
                                break;
                            }
                            case 12: {
                                retval = String.valueOf(retval) + "4096 " + ConformanceException.message("X.224", "13.3.4b", "not allowed in class 0");
                                break;
                            }
                            case 11: {
                                retval = String.valueOf(retval) + "2048";
                                break;
                            }
                            case 10: {
                                retval = String.valueOf(retval) + "1024";
                                break;
                            }
                            case 9: {
                                retval = String.valueOf(retval) + "512";
                                break;
                            }
                            case 8: {
                                retval = String.valueOf(retval) + "256";
                                break;
                            }
                            case 7: {
                                retval = String.valueOf(retval) + "128";
                                break;
                            }
                            default: {
                                retval = String.valueOf(retval) + ConformanceException.message("X.224", "13.3.4b", "invalid size specifier : 0x" + Integer.toHexString(sizeCode));
                            }
                        }
                        if (parameterLength != 1) {
                            retval = String.valueOf(retval) + ConformanceException.message("X.224", "13.3.4b", "invalid length :" + parameterLength);
                        }
                        retval = String.valueOf(retval) + "\n";
                        break;
                    }
                    case 198: {
                        retval = String.valueOf(retval) + "additional options = 0x" + (this.data[offset + 2] & 0xFF) + " " + ConformanceException.message("X.224", "13.3.4f", "not used for Class 0");
                        retval = String.valueOf(retval) + "\n";
                        break;
                    }
                    default: {
                        retval = String.valueOf(retval) + ConformanceException.message("X.224", "13.3.4", "Invalid parameter (0x" + Integer.toHexString(parameterCode) + ")") + "\n";
                    }
                }
            }
            if (this.tpduCode == 128) {
                switch (parameterCode) {
                    case 224: {
                        retval = String.valueOf(retval) + "user-defined, length : " + parameterLength + "\n";
                        break;
                    }
                    default: {
                        retval = String.valueOf(retval) + ConformanceException.message("X.224", "13.5.4", "Invalid parameter (0x" + Integer.toHexString(parameterCode) + ")") + "\n";
                    }
                }
            }
            if (this.tpduCode == 112) {
                switch (parameterCode) {
                    case 193: {
                        retval = String.valueOf(retval) + "Invalid TPDU.  " + parameterLength + " bytes follow :\n";
                        retval = String.valueOf(retval) + HexDecoder.hexify(this.data, offset + 2, parameterLength, String.valueOf(prefix) + "  ");
                        retval = String.valueOf(retval) + "\n";
                        break;
                    }
                    default: {
                        retval = String.valueOf(retval) + ConformanceException.message("X.224", "13.12.4", "Invalid parameter (0x" + Integer.toHexString(parameterCode) + ")") + "\n";
                    }
                }
            }
            offset = this.getParamOffset(++paramNum);
        }
        return retval;
    }

    public int getLengthIndicator() {
        return this.li;
    }

    protected int getParamOffset(int parameterNumber) {
        if (this.variablePos == -1) {
            return -1;
        }
        int offset = this.variablePos;
        int count = 0;
        while (count < parameterNumber) {
            offset += this.data[offset + 1] & 0xFF;
            if ((offset += 2) - this.variablePos > this.variableLen) {
                return -1;
            }
            ++count;
        }
        return offset;
    }

    public int getTpduCode() {
        return this.tpduCode;
    }

    public String getTpduName() {
        return this.tpduName;
    }

    public byte[] getUserData() {
        if (this.userDataLen <= 0) {
            return new byte[0];
        }
        byte[] retval = new byte[this.userDataLen];
        System.arraycopy(this.data, this.userDataPos, retval, 0, this.userDataLen);
        return retval;
    }

    public boolean isEOT() throws ConformanceException {
        if (this.nreot == -1) {
            throw new ConformanceException("X.224", "13", "EOT field only valid for DT TPDU");
        }
        return (this.nreot & 0x80) != 0;
    }

    public static void main(String[] args) {
        logger.info("Main code for TPDU class");
        try {
            byte[] byArray = new byte[2];
            byArray[0] = 1;
            TPDU tpdu = new TPDU(byArray, 0, 2);
            logger.info("created new tpdu ok");
        }
        catch (Exception e) {
            logger.info("failed to create TPDU : " + e.getMessage());
        }
    }
}

