/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.ConformanceException;
import com.nickoh.snooper.HexDecoder;
import com.nickoh.snooper.SPDU;

public class TSDU {
    private static final String moduleVersion = "1.0";
    protected byte[] data = null;

    public TSDU(byte[] byteArray) {
        this(byteArray, 0, byteArray.length);
    }

    public TSDU(byte[] byteArray, int startPos, int length) {
        if (byteArray == null) {
            throw new ArrayIndexOutOfBoundsException("empty array");
        }
        if (startPos + length > byteArray.length) {
            throw new ArrayIndexOutOfBoundsException("length too big");
        }
        this.data = new byte[length];
        System.arraycopy(byteArray, startPos, this.data, 0, length);
    }

    public String formatContents(String prefix) {
        String retval = "";
        int count = 0;
        while (true) {
            try {
                SPDU spdu = this.getSPDU(count);
                if (spdu == null) {
                    return retval;
                }
                retval = String.valueOf(retval) + prefix + "SPDU #" + count + " is a " + spdu.getSiName() + "\n";
                retval = String.valueOf(retval) + spdu.formatParameters(String.valueOf(prefix) + "  ");
                byte[] ui = spdu.getUserInfo();
                retval = ui == null ? String.valueOf(retval) + prefix + "  No user info for this SPDU\n" : String.valueOf(retval) + prefix + "  " + ui.length + " (0x" + Integer.toHexString(ui.length) + ") bytes of user info\n";
            }
            catch (ConformanceException e) {
                retval = String.valueOf(retval) + prefix + "SPDU #" + count + " could not be decoded : " + e.getMessage() + "\n";
                retval = String.valueOf(retval) + prefix + "-- dump of TSDU follows :\n";
                retval = String.valueOf(retval) + HexDecoder.hexify(this.data, this.data.length, String.valueOf(prefix) + "    ");
                retval = String.valueOf(retval) + prefix + "-- end of dump\n";
                return retval;
            }
            ++count;
        }
    }

    public byte[] getContents() {
        return this.data;
    }

    public SPDU getSPDU(int index) throws ConformanceException {
        int spduSize;
        int offset = 0;
        int count = 0;
        do {
            int si;
            if ((si = this.data[offset] & 0xFF) == 5 || si == 33) {
                if (count != 0) {
                    throw new ConformanceException("X.225", "6.3.7", "Category 1 SPDU must be only SPDU in a TSDU");
                }
                if (count == index) {
                    byte[] temp = new byte[this.data.length];
                    System.arraycopy(this.data, 0, temp, 0, this.data.length);
                    return new SPDU(temp, si == 5 ? "Expedited (EX) X.225 \u00a78.3.12" : "Typed Data (TD) X.225 \u00a78.3.13");
                }
            }
            int liLength = 1;
            int li = this.data[offset + 1] & 0xFF;
            if (li == 255) {
                liLength = 3;
                li = (this.data[offset + 2] & 0xFF) * 256 + (this.data[offset + 3] & 0xFF);
            }
            int paramOffset = offset + 1 + liLength;
            int userInfoOffset = paramOffset + li;
            int userInfoLen = 0;
            String siName = null;
            if (si == 1) {
                siName = "Give Tokens (GT) X.225 \u00a78.3.16 ";
                if (count != 0) {
                    siName = "Data Transfer (DT) X.225 \u00a78.3.11";
                    userInfoLen = this.data.length - userInfoOffset;
                }
            } else {
                switch (si) {
                    case 13: {
                        siName = "Connect (CN) X.225 \u00a78.3.1";
                        break;
                    }
                    case 16: {
                        siName = "Overflow Accept (OA) X.225 \u00a78.3.2";
                        break;
                    }
                    case 15: {
                        siName = "Connect Data Overflow (CDO) X.225 \u00a78.3.3";
                        break;
                    }
                    case 14: {
                        siName = "Accept (AC) X.225 \u00a78.3.4";
                        break;
                    }
                    case 12: {
                        siName = "Refuse (RF) X.225 \u00a78.3.5";
                        break;
                    }
                    case 9: {
                        siName = "Finish (FN) X.225 \u00a78.3.6";
                        break;
                    }
                    case 10: {
                        siName = "Disconnect (DN) X.225 \u00a78.3.7";
                        break;
                    }
                    case 8: {
                        siName = "Not Finished (NF) X.225 \u00a78.3.8";
                        break;
                    }
                    case 61: {
                        siName = "Capability Data (CD) X.225 \u00a78.3.14";
                        break;
                    }
                    case 62: {
                        siName = "Capability Data Ack (CDA) X.225 \u00a78.3.15";
                        break;
                    }
                    case 2: {
                        siName = "Please Tokens (PT) X.225 \u00a78.3.17";
                        break;
                    }
                    case 21: {
                        siName = "Give Tokens Confirm (GTC) X.225 \u00a78.3.18";
                        break;
                    }
                    case 22: {
                        siName = "Give Tokens Ack (GTA) X.225 \u00a78.3.19";
                        break;
                    }
                    case 49: {
                        siName = "Minor Sync Point (MIP) X.225 \u00a78.3.20";
                        break;
                    }
                    case 50: {
                        siName = "Minor Sync (MIA) X.225 \u00a78.3.21";
                        break;
                    }
                    case 53: {
                        siName = "Resynchronize (RS) X.225 \u00a78.3.24";
                        break;
                    }
                    case 34: {
                        siName = "Resynchronize Ack (RA) X.225 \u00a78.3.25";
                        break;
                    }
                    case 7: {
                        siName = "Prepare (PR) X.225 \u00a78.3.26";
                        break;
                    }
                    case 0: {
                        siName = "Exception Report (ER) X.225 \u00a78.3.27";
                        break;
                    }
                    case 48: {
                        siName = "Exception Data (ED) X.225 \u00a78.3.28";
                        break;
                    }
                    case 45: {
                        siName = "Activity Start (AS) X.225 \u00a78.3.20";
                        break;
                    }
                    case 29: {
                        siName = "Activity Resume (AR) X.225 \u00a78.3.30";
                        break;
                    }
                    case 57: {
                        siName = "Activity Discard (AD) X.225 \u00a78.3.33";
                        break;
                    }
                    case 58: {
                        siName = "Activity Discard Ack (ADA) X.225 \u00a78.3.34";
                        break;
                    }
                    case 41: {
                        siName = "Major Sync Point (MAP)  X.225 \u00a78.3.22 or Activity End (AE) X.225 \u00a78.3.35";
                        break;
                    }
                    case 42: {
                        siName = "Major Sync Ack (MAA) X.225 \u00a78.3.23 or Activity End Ack (AEA) X.225 \u00a78.3.36";
                        break;
                    }
                    case 25: {
                        if (count == 0) {
                            siName = "Abort (AB) X.225 \u00a78.3.9";
                            break;
                        }
                        siName = "Activity Interrupt (AI) X.225 \u00a78.3.31";
                        break;
                    }
                    case 26: {
                        if (count == 0) {
                            siName = "Abort Accept (AA) X.225 \u00a78.3.10";
                            break;
                        }
                        siName = "Activity Interrupt Ack (AIA) X.225 \u00a78.3.32";
                        break;
                    }
                    default: {
                        throw new ConformanceException("X.225", "8.3", "Unrecognized SI field : #" + si);
                    }
                }
            }
            spduSize = 1 + liLength + li + userInfoLen;
            if (count == index) {
                byte[] temp = new byte[spduSize];
                System.arraycopy(this.data, offset, temp, 0, spduSize);
                return new SPDU(temp, siName);
            }
            ++count;
        } while ((offset += spduSize) < this.data.length);
        return null;
    }

    public byte[] getUserInfo() throws ConformanceException {
        int count = 0;
        SPDU spdu;
        while ((spdu = this.getSPDU(count)) != null) {
            byte[] ui = spdu.getUserInfo();
            if (ui != null) {
                return ui;
            }
            ++count;
        }
        return null;
    }
}

