/*
 * Decompiled with CFR 0.152.
 */
package com.nickoh.snooper;

import com.nickoh.snooper.Decoder;
import com.nickoh.snooper.OnewaySnooper;
import com.nickoh.util.NickohLogHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Logger;

public class TwowaySnooper
implements Runnable {
    private static String moduleVersion = "1.0";
    private static Logger logger = NickohLogHandler.getLogger();
    private Socket serverSocket = null;
    private OnewaySnooper fromClient = null;
    private OnewaySnooper fromServer = null;
    private Decoder serverDecoder = null;
    private Decoder clientDecoder = null;
    private Socket clientSocket = null;
    protected String clientName = null;
    protected String serverName = null;

    public TwowaySnooper(InetAddress server, int serverPort, Socket clientSocket, Decoder clientDecoder, Decoder serverDecoder) throws IOException {
        logger.info("Twowaysnooper constructing");
        if (server == null || clientSocket == null || serverDecoder == null || clientDecoder == null) {
            throw new NullPointerException();
        }
        this.clientDecoder = clientDecoder;
        this.serverDecoder = serverDecoder;
        this.clientSocket = clientSocket;
        this.serverSocket = new Socket(server, serverPort);
        this.fromClient = new OnewaySnooper(clientSocket, this.serverSocket, null);
        this.fromServer = new OnewaySnooper(this.serverSocket, clientSocket, null);
        this.clientName = clientSocket.getInetAddress().getHostName();
        this.serverName = server.getHostName();
        logger.info("Twowaysnooper constructor done");
    }

    public void run() {
        logger.info("TwowaySnooper.run called");
        this.fromClient.setParentThread(Thread.currentThread());
        this.fromServer.setParentThread(Thread.currentThread());
        Thread child1 = new Thread(this.fromServer);
        Thread child2 = new Thread(this.fromClient);
        child1.start();
        child2.start();
        int currentPriority = Thread.currentThread().getPriority();
        if (currentPriority > 1) {
            Thread.currentThread().setPriority(1);
        }
        logger.info("TwoWaySnooper thread " + Thread.currentThread() + " starting, priority dropped from " + currentPriority + " to " + Thread.currentThread().getPriority());
        boolean clientClosed = true;
        while (!this.fromClient.isSnoopFinished() || !this.fromServer.isSnoopFinished()) {
            byte[] data;
            try {
                if (this.fromClient.isSnoopFinished() || this.fromServer.isSnoopFinished()) {
                    if (this.fromServer.isSnoopFinished() && !this.fromClient.isSnoopFinished()) {
                        clientClosed = false;
                    }
                    logger.info("closing both sockets");
                    this.serverSocket.close();
                    this.clientSocket.close();
                }
            }
            catch (IOException iOException) {}
            try {
                while (!this.fromClient.isSnoopFinished() || !this.fromServer.isSnoopFinished()) {
                    logger.info("snoops not finished, doCommunication still sleeping");
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException e) {
                logger.info("doCommunication got interrupt");
            }
            while ((data = this.fromClient.getPendingData()) != null) {
                logger.info(Thread.currentThread() + " calling clientDecoder");
                this.clientDecoder.decodeData(data);
            }
            while ((data = this.fromServer.getPendingData()) != null) {
                logger.info(Thread.currentThread() + " calling serverDecoder");
                this.serverDecoder.decodeData(data);
            }
        }
        if (clientClosed) {
            this.clientDecoder.displayMessage("\nConnection shut down by " + this.clientName + " at " + Decoder.getTimeNow() + "\n\n");
        } else {
            this.serverDecoder.displayMessage("\nConnection shut down by " + this.serverName + " at " + Decoder.getTimeNow() + "\n\n");
        }
        this.clientDecoder.close();
        this.serverDecoder.close();
        logger.info("snoops finished, TwowaySnooper thread exiting");
    }

    public void shutdown() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.clientSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

